@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property nameServers The list of DNS server IP addresses.
 * @property options The structure of options. See `options` below.
 * @property searches The list of DNS lookup domains.
 */
public data class ContainerGroupDnsConfig(
    public val nameServers: List<String>? = null,
    public val options: List<ContainerGroupDnsConfigOption>? = null,
    public val searches: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupDnsConfig): ContainerGroupDnsConfig = ContainerGroupDnsConfig(
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            options = javaType.options().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupDnsConfigOption.Companion.toKotlin(args0)
                })
            }),
            searches = javaType.searches().map({ args0 -> args0 }),
        )
    }
}
