@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hostnames The information about the host.
 * @property ip The IP address of the host.
 */
public data class ContainerGroupHostAlias(
    public val hostnames: List<String>? = null,
    public val ip: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupHostAlias): ContainerGroupHostAlias = ContainerGroupHostAlias(
            hostnames = javaType.hostnames().map({ args0 -> args0 }),
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
        )
    }
}
