@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
 * @property server The address of the image repository. It is required when `image_registry_credential` is configured.
 * @property userName The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
 */
public data class ContainerGroupImageRegistryCredential(
    public val password: String,
    public val server: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupImageRegistryCredential): ContainerGroupImageRegistryCredential = ContainerGroupImageRegistryCredential(
            password = javaType.password(),
            server = javaType.server(),
            userName = javaType.userName(),
        )
    }
}
