@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property sysctls Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
 */
public data class ContainerGroupSecurityContext(
    public val sysctls: List<ContainerGroupSecurityContextSysctl>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupSecurityContext): ContainerGroupSecurityContext = ContainerGroupSecurityContext(
            sysctls = javaType.sysctls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupSecurityContextSysctl.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
