@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property containerGroupId The id if ContainerGroup.
 * @property containerGroupName The name of ContainerGroup.
 * @property containers A list of containers. Each element contains the following attributes:
 * @property cpu The amount of CPU resources allocated to the container group.
 * @property discount
 * @property dnsConfigs The DNS settings.
 * @property eciSecurityContexts The security context of the container group.
 * @property eniInstanceId The ID of the ENI instance.
 * @property events The events of the container group. Maximum: `50`.
 * @property expiredTime The time when the container group failed to run due to overdue payments. The timestamp follows the UTC and RFC3339 formats.
 * @property failedTime The time when the container failed to run tasks. The timestamp follows the UTC and RFC3339 formats.
 * @property hostAliases The mapping between host names and IP addresses for a container in the container group.
 * @property id The ID of the Container Group.
 * @property initContainers A list of init containers. Each element contains the following attributes:
 * @property instanceType The type of the ECS instance.
 * @property internetIp The public IP address of the container group.
 * @property intranetIp The internal IP address of the container group.
 * @property ipv6Address The IPv6 address.
 * @property memory The amount of memory resources allocated to the container group.
 * @property ramRoleName The RAM role that the container group assumes. ECI and ECS share the same RAM role.
 * @property resourceGroupId The ID of the resource group to which the container group belongs. If you have not specified a resource group for the container group, it is added to the default resource group.
 * @property restartPolicy The restart policy of the container group.
 * @property securityGroupId The ID of the security group.
 * @property status The status of container.
 * @property succeededTime The time when all containers in the container group completed running the specified tasks. The timestamp follows the UTC and RFC 3339 formats. For example, 2018-08-02T15:00:00Z.
 * @property tags The tags attached to the container group. Each tag is a key-value pair. You can attach up to 20 tags to a container group.
 * @property volumes The information about the mounted volume. You can mount up to 20 volumes.
 * @property vpcId The if of vpc.
 * @property vswitchId The vswitch id.
 * @property zoneId The IDs of the zones where the container groups are deployed. If this parameter is not set, the system automatically selects the zones. By default, no value is specified.
 */
public data class GetContainerGroupsGroup(
    public val containerGroupId: String,
    public val containerGroupName: String,
    public val containers: List<GetContainerGroupsGroupContainer>,
    public val cpu: Double,
    public val discount: Int,
    public val dnsConfigs: List<GetContainerGroupsGroupDnsConfig>,
    public val eciSecurityContexts: List<GetContainerGroupsGroupEciSecurityContext>,
    public val eniInstanceId: String,
    public val events: List<GetContainerGroupsGroupEvent>,
    public val expiredTime: String,
    public val failedTime: String,
    public val hostAliases: List<GetContainerGroupsGroupHostAlias>,
    public val id: String,
    public val initContainers: List<GetContainerGroupsGroupInitContainer>,
    public val instanceType: String,
    public val internetIp: String,
    public val intranetIp: String,
    public val ipv6Address: String,
    public val memory: Double,
    public val ramRoleName: String,
    public val resourceGroupId: String,
    public val restartPolicy: String,
    public val securityGroupId: String,
    public val status: String,
    public val succeededTime: String,
    public val tags: Map<String, String>,
    public val volumes: List<GetContainerGroupsGroupVolume>,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetContainerGroupsGroup): GetContainerGroupsGroup = GetContainerGroupsGroup(
            containerGroupId = javaType.containerGroupId(),
            containerGroupName = javaType.containerGroupName(),
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupContainer.Companion.toKotlin(args0)
                })
            }),
            cpu = javaType.cpu(),
            discount = javaType.discount(),
            dnsConfigs = javaType.dnsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupDnsConfig.Companion.toKotlin(args0)
                })
            }),
            eciSecurityContexts = javaType.eciSecurityContexts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupEciSecurityContext.Companion.toKotlin(args0)
                })
            }),
            eniInstanceId = javaType.eniInstanceId(),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupEvent.Companion.toKotlin(args0)
                })
            }),
            expiredTime = javaType.expiredTime(),
            failedTime = javaType.failedTime(),
            hostAliases = javaType.hostAliases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupHostAlias.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            initContainers = javaType.initContainers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupInitContainer.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType(),
            internetIp = javaType.internetIp(),
            intranetIp = javaType.intranetIp(),
            ipv6Address = javaType.ipv6Address(),
            memory = javaType.memory(),
            ramRoleName = javaType.ramRoleName(),
            resourceGroupId = javaType.resourceGroupId(),
            restartPolicy = javaType.restartPolicy(),
            securityGroupId = javaType.securityGroupId(),
            status = javaType.status(),
            succeededTime = javaType.succeededTime(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupVolume.Companion.toKotlin(args0)
                })
            }),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
