@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args The arguments passed to the commands. Maximum: `10`.
 * @property commands The commands run by the container. You can define a maximum of 20 commands. Minimum length per string: 256 characters.
 * @property cpu The amount of CPU resources allocated to the container.
 * @property environmentVars The environment variables.
 * @property gpu The amount of GPU resources allocated to the container.
 * @property image The image of the container.
 * @property imagePullPolicy The policy for pulling an image.
 * @property memory The amount of memory resources allocated to the container.
 * @property name The name of the container.
 * @property ports The list of exposed ports and protocols. Maximum: 100.
 * @property ready Indicates whether the container is ready.
 * @property restartCount The number of times that the container has restarted.
 * @property volumeMounts The list of volumes mounted to the container.
 * @property workingDir The working directory of the container.
 */
public data class GetContainerGroupsGroupContainer(
    public val args: List<String>,
    public val commands: List<String>,
    public val cpu: Double,
    public val environmentVars: List<GetContainerGroupsGroupContainerEnvironmentVar>,
    public val gpu: Int,
    public val image: String,
    public val imagePullPolicy: String,
    public val memory: Double,
    public val name: String,
    public val ports: List<GetContainerGroupsGroupContainerPort>,
    public val ready: Boolean,
    public val restartCount: Int,
    public val volumeMounts: List<GetContainerGroupsGroupContainerVolumeMount>,
    public val workingDir: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetContainerGroupsGroupContainer): GetContainerGroupsGroupContainer = GetContainerGroupsGroupContainer(
            args = javaType.args().map({ args0 -> args0 }),
            commands = javaType.commands().map({ args0 -> args0 }),
            cpu = javaType.cpu(),
            environmentVars = javaType.environmentVars().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupContainerEnvironmentVar.Companion.toKotlin(args0)
                })
            }),
            gpu = javaType.gpu(),
            image = javaType.image(),
            imagePullPolicy = javaType.imagePullPolicy(),
            memory = javaType.memory(),
            name = javaType.name(),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupContainerPort.Companion.toKotlin(args0)
                })
            }),
            ready = javaType.ready(),
            restartCount = javaType.restartCount(),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupContainerVolumeMount.Companion.toKotlin(args0)
                })
            }),
            workingDir = javaType.workingDir(),
        )
    }
}
