@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mountPath The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
 * @property name The name of the volume. The name is the same as the volume you selected when you purchased the container.
 * @property readOnly Default value: `false`.
 */
public data class GetContainerGroupsGroupContainerVolumeMount(
    public val mountPath: String,
    public val name: String,
    public val readOnly: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetContainerGroupsGroupContainerVolumeMount): GetContainerGroupsGroupContainerVolumeMount = GetContainerGroupsGroupContainerVolumeMount(
            mountPath = javaType.mountPath(),
            name = javaType.name(),
            readOnly = javaType.readOnly(),
        )
    }
}
