@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property nameServers The list of DNS server IP addresses.
 * @property options The list of objects. Each object is a name-value pair. The value is optional.
 * @property searches The list of DNS lookup domains.
 */
public data class GetContainerGroupsGroupDnsConfig(
    public val nameServers: List<String>,
    public val options: List<GetContainerGroupsGroupDnsConfigOption>,
    public val searches: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetContainerGroupsGroupDnsConfig): GetContainerGroupsGroupDnsConfig = GetContainerGroupsGroupDnsConfig(
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            options = javaType.options().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupDnsConfigOption.Companion.toKotlin(args0)
                })
            }),
            searches = javaType.searches().map({ args0 -> args0 }),
        )
    }
}
