@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property count The number of events.
 * @property firstTimestamp The time when the event started.
 * @property lastTimestamp The time when the event ended.
 * @property message The content of the event.
 * @property name The name of the object to which the event belongs.
 * @property reason The name of the event.
 * @property type The type of the event. Valid values: Normal and Warning.
 */
public data class GetContainerGroupsGroupEvent(
    public val count: Int,
    public val firstTimestamp: String,
    public val lastTimestamp: String,
    public val message: String,
    public val name: String,
    public val reason: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetContainerGroupsGroupEvent): GetContainerGroupsGroupEvent = GetContainerGroupsGroupEvent(
            count = javaType.count(),
            firstTimestamp = javaType.firstTimestamp(),
            lastTimestamp = javaType.lastTimestamp(),
            message = javaType.message(),
            name = javaType.name(),
            reason = javaType.reason(),
            type = javaType.type(),
        )
    }
}
