@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property configFileVolumeConfigFileToPaths The list of configuration file paths.
 * @property diskVolumeDiskId The ID of DiskVolume.
 * @property diskVolumeFsType The type of DiskVolume.
 * @property flexVolumeDriver The name of the FlexVolume driver.
 * @property flexVolumeFsType The type of the mounted file system. The default value is determined by the script of FlexVolume.
 * @property flexVolumeOptions The list of FlexVolume objects.
 * @property name The name of the volume.
 * @property nfsVolumePath The path to the NFS volume.
 * @property nfsVolumeReadOnly Default value: `false`.
 * @property nfsVolumeServer The address of the NFS server.
 * @property type The type of the volume. Currently, the following types of volumes are supported: EmptyDirVolume, NFSVolume, ConfigFileVolume, and FlexVolume.
 */
public data class GetContainerGroupsGroupVolume(
    public val configFileVolumeConfigFileToPaths: List<GetContainerGroupsGroupVolumeConfigFileVolumeConfigFileToPath>,
    public val diskVolumeDiskId: String,
    public val diskVolumeFsType: String,
    public val flexVolumeDriver: String,
    public val flexVolumeFsType: String,
    public val flexVolumeOptions: String,
    public val name: String,
    public val nfsVolumePath: String,
    public val nfsVolumeReadOnly: Boolean,
    public val nfsVolumeServer: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetContainerGroupsGroupVolume): GetContainerGroupsGroupVolume = GetContainerGroupsGroupVolume(
            configFileVolumeConfigFileToPaths = javaType.configFileVolumeConfigFileToPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroupVolumeConfigFileVolumeConfigFileToPath.Companion.toKotlin(args0)
                })
            }),
            diskVolumeDiskId = javaType.diskVolumeDiskId(),
            diskVolumeFsType = javaType.diskVolumeFsType(),
            flexVolumeDriver = javaType.flexVolumeDriver(),
            flexVolumeFsType = javaType.flexVolumeFsType(),
            flexVolumeOptions = javaType.flexVolumeOptions(),
            name = javaType.name(),
            nfsVolumePath = javaType.nfsVolumePath(),
            nfsVolumeReadOnly = javaType.nfsVolumeReadOnly(),
            nfsVolumeServer = javaType.nfsVolumeServer(),
            type = javaType.type(),
        )
    }
}
