@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getContainerGroups.
 * @property containerGroupName
 * @property enableDetails
 * @property groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property limit
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property resourceGroupId
 * @property status
 * @property tags
 * @property vswitchId
 * @property withEvent
 * @property zoneId
 */
public data class GetContainerGroupsResult(
    public val containerGroupName: String? = null,
    public val enableDetails: Boolean? = null,
    public val groups: List<GetContainerGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val limit: Int? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vswitchId: String? = null,
    public val withEvent: Boolean? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetContainerGroupsResult): GetContainerGroupsResult = GetContainerGroupsResult(
            containerGroupName = javaType.containerGroupName().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            limit = javaType.limit().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
            withEvent = javaType.withEvent().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
