@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerGroupId The id of container group.
 * @property events Image cache pulls image event information.
 * @property expireDateTime The time of expired.
 * @property id The ID of the ECI Image Cache.
 * @property imageCacheId The id of the ECI Image Cache.
 * @property imageCacheName The name of ECI Image Cache.
 * @property images The list of cached images.
 * @property progress The progress of ECI Image Cache.
 * @property snapshotId The id of snapshot.
 * @property status The status of ECI Image Cache.
 */
public data class GetImageCachesCach(
    public val containerGroupId: String,
    public val events: List<GetImageCachesCachEvent>,
    public val expireDateTime: String,
    public val id: String,
    public val imageCacheId: String,
    public val imageCacheName: String,
    public val images: List<String>,
    public val progress: String,
    public val snapshotId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetImageCachesCach): GetImageCachesCach = GetImageCachesCach(
            containerGroupId = javaType.containerGroupId(),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetImageCachesCachEvent.Companion.toKotlin(args0)
                })
            }),
            expireDateTime = javaType.expireDateTime(),
            id = javaType.id(),
            imageCacheId = javaType.imageCacheId(),
            imageCacheName = javaType.imageCacheName(),
            images = javaType.images().map({ args0 -> args0 }),
            progress = javaType.progress(),
            snapshotId = javaType.snapshotId(),
            status = javaType.status(),
        )
    }
}
