@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getImageCaches.
 * @property caches A list of caches. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list ids of ECI Image Cache.
 * @property image
 * @property imageCacheName The name of the ECI Image Cache.
 * @property nameRegex
 * @property names A list of ECI Image Cache names.
 * @property outputFile
 * @property snapshotId The id of snapshot.
 * @property status The status of ECI Image Cache.
 */
public data class GetImageCachesResult(
    public val caches: List<GetImageCachesCach>,
    public val id: String,
    public val ids: List<String>,
    public val image: String? = null,
    public val imageCacheName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val snapshotId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetImageCachesResult): GetImageCachesResult = GetImageCachesResult(
            caches = javaType.caches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetImageCachesCach.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            imageCacheName = javaType.imageCacheName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
