@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property cpu The Number of CPU.
 * @property createTime The creation time of the virtual node.
 * @property eniInstanceId The ENI instance ID.
 * @property events The event list.
 * @property id The ID of the Virtual Node.
 * @property internetIp The IP address of a public network.
 * @property intranetIp The private IP address of the RDS instance.
 * @property memory The memory size.
 * @property ramRoleName The ram role.
 * @property resourceGroupId The resource group ID.
 * @property securityGroupId The security group ID.
 * @property status The Status of the virtual node.
 * @property tags A mapping of tags to assign to the resource.
 * @property virtualNodeId Of the virtual node number.
 * @property virtualNodeName The name of the virtual node.
 * @property vpcId
 * @property vswitchId The vswitch id.
 * @property zoneId The Zone.
 */
public data class GetVirtualNodesNode(
    public val cpu: Int,
    public val createTime: String,
    public val eniInstanceId: String,
    public val events: List<GetVirtualNodesNodeEvent>,
    public val id: String,
    public val internetIp: String,
    public val intranetIp: String,
    public val memory: Int,
    public val ramRoleName: String,
    public val resourceGroupId: String,
    public val securityGroupId: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val virtualNodeId: String,
    public val virtualNodeName: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetVirtualNodesNode): GetVirtualNodesNode = GetVirtualNodesNode(
            cpu = javaType.cpu(),
            createTime = javaType.createTime(),
            eniInstanceId = javaType.eniInstanceId(),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetVirtualNodesNodeEvent.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            internetIp = javaType.internetIp(),
            intranetIp = javaType.intranetIp(),
            memory = javaType.memory(),
            ramRoleName = javaType.ramRoleName(),
            resourceGroupId = javaType.resourceGroupId(),
            securityGroupId = javaType.securityGroupId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            virtualNodeId = javaType.virtualNodeId(),
            virtualNodeName = javaType.virtualNodeName(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
