@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property count The number of occurrences.
 * @property firstTimestamp The first presentation time stamp.
 * @property lastTimestamp The most recent time stamp.
 * @property message The event of the message body.
 * @property name The name of the event.
 * @property reason The causes of the incident.
 * @property type The Event type.
 */
public data class GetVirtualNodesNodeEvent(
    public val count: Int,
    public val firstTimestamp: String,
    public val lastTimestamp: String,
    public val message: String,
    public val name: String,
    public val reason: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetVirtualNodesNodeEvent): GetVirtualNodesNodeEvent = GetVirtualNodesNodeEvent(
            count = javaType.count(),
            firstTimestamp = javaType.firstTimestamp(),
            lastTimestamp = javaType.lastTimestamp(),
            message = javaType.message(),
            name = javaType.name(),
            reason = javaType.reason(),
            type = javaType.type(),
        )
    }
}
