@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVirtualNodes.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property nodes
 * @property outputFile
 * @property resourceGroupId
 * @property securityGroupId
 * @property status
 * @property tags
 * @property virtualNodeName
 * @property vswitchId
 */
public data class GetVirtualNodesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val nodes: List<GetVirtualNodesNode>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val securityGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val virtualNodeName: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetVirtualNodesResult): GetVirtualNodesResult = GetVirtualNodesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.GetVirtualNodesNode.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            securityGroupId = javaType.securityGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            virtualNodeName = javaType.virtualNodeName().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
