@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getZones.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property zones
 */
public data class GetZonesResult(
    public val id: String,
    public val outputFile: String? = null,
    public val zones: List<GetZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.GetZonesResult): GetZonesResult =
            GetZonesResult(
                id = javaType.id(),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                zones = javaType.zones().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eci.kotlin.outputs.GetZonesZone.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
