@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password The password of the Image Registry.
 * @property server The address of Image Registry without `http://` or `https://`.
 * @property userName The user name of Image Registry.
 */
public data class ImageCacheImageRegistryCredential(
    public val password: String? = null,
    public val server: String? = null,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ImageCacheImageRegistryCredential): ImageCacheImageRegistryCredential = ImageCacheImageRegistryCredential(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
