@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin

import com.pulumi.alicloud.ecp.EcpFunctions.getInstanceTypesPlain
import com.pulumi.alicloud.ecp.EcpFunctions.getInstancesPlain
import com.pulumi.alicloud.ecp.EcpFunctions.getKeyPairsPlain
import com.pulumi.alicloud.ecp.EcpFunctions.getZonesPlain
import com.pulumi.alicloud.ecp.kotlin.inputs.GetInstanceTypesPlainArgs
import com.pulumi.alicloud.ecp.kotlin.inputs.GetInstanceTypesPlainArgsBuilder
import com.pulumi.alicloud.ecp.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.ecp.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.ecp.kotlin.inputs.GetKeyPairsPlainArgs
import com.pulumi.alicloud.ecp.kotlin.inputs.GetKeyPairsPlainArgsBuilder
import com.pulumi.alicloud.ecp.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.ecp.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.ecp.kotlin.outputs.GetInstanceTypesResult
import com.pulumi.alicloud.ecp.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.ecp.kotlin.outputs.GetKeyPairsResult
import com.pulumi.alicloud.ecp.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ecp.kotlin.outputs.GetInstanceTypesResult.Companion.toKotlin as getInstanceTypesResultToKotlin
import com.pulumi.alicloud.ecp.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.ecp.kotlin.outputs.GetKeyPairsResult.Companion.toKotlin as getKeyPairsResultToKotlin
import com.pulumi.alicloud.ecp.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object EcpFunctions {
    /**
     * This data source provides the available instance types with the Cloud Phone (ECP) Instance of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.158.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecp.getInstanceTypes({});
     * export const firstEcpInstanceTypesInstanceType = _default.then(_default => _default.instanceTypes?.[0]?.instanceType);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecp.get_instance_types()
     * pulumi.export("firstEcpInstanceTypesInstanceType", default.instance_types[0].instance_type)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecp.GetInstanceTypes.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcpInstanceTypesInstanceType"] = @default&#46;Apply(@default => @default&#46;Apply(getInstanceTypesResult => getInstanceTypesResult&#46;InstanceTypes[0]?.InstanceType)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ecp.GetInstanceTypes(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcpInstanceTypesInstanceType", _default.InstanceTypes[0].InstanceType)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecp.EcpFunctions;
     * import com.pulumi.alicloud.ecp.inputs.GetInstanceTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcpFunctions.getInstanceTypes();
     *         ctx.export("firstEcpInstanceTypesInstanceType", default_.instanceTypes()[0].instanceType());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecp:getInstanceTypes
     *       Arguments: {}
     * outputs:
     *   firstEcpInstanceTypesInstanceType: ${default.instanceTypes[0].instanceType}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceTypes.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: GetInstanceTypesPlainArgs): GetInstanceTypesResult =
        getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypes].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(outputFile: String? = null): GetInstanceTypesResult {
        val argument = GetInstanceTypesPlainArgs(
            outputFile = outputFile,
        )
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecp&#46;kotlin&#46;inputs&#46;GetInstanceTypesPlainArgs].
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: suspend GetInstanceTypesPlainArgsBuilder.() -> Unit): GetInstanceTypesResult {
        val builder = GetInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecp Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.158.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecp.getZones({});
     * const defaultGetInstanceTypes = alicloud.ecp.getInstanceTypes({});
     * const countSize = _default.then(_default => _default.zones).length;
     * const zoneId = Promise.all([_default, countSize])&#46;then(([_default, countSize]) => _default&#46;zones[countSize - 1].zoneId);
     * const instanceTypeCountSize = defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes).length;
     * const instanceType = Promise.all([defaultGetInstanceTypes, instanceTypeCountSize])&#46;then(([defaultGetInstanceTypes, instanceTypeCountSize]) => defaultGetInstanceTypes&#46;instanceTypes[instanceTypeCountSize - 1].instanceType);
     * const defaultGetNetworks = alicloud.vpc.getNetworks({
     *     nameRegex: "default-NODELETING",
     * });
     * const defaultGetSwitches = defaultGetNetworks.then(defaultGetNetworks => alicloud.vpc.getSwitches({
     *     vpcId: defaultGetNetworks.ids?.[0],
     *     zoneId: zoneId,
     * }));
     * const group = new alicloud.ecs.SecurityGroup("group", {
     *     name: name,
     *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
     * });
     * const defaultKeyPair = new alicloud.ecp.KeyPair("default", {
     *     keyPairName: name,
     *     publicKeyBody: "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
     * });
     * const defaultInstance = new alicloud.ecp.Instance("default", {
     *     instanceName: name,
     *     description: name,
     *     force: true,
     *     keyPairName: defaultKeyPair.keyPairName,
     *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
     *     imageId: "android_9_0_0_release_2851157_20211201.vhd",
     *     instanceType: Promise.all([defaultGetInstanceTypes, instanceTypeCountSize])&#46;then(([defaultGetInstanceTypes, instanceTypeCountSize]) => defaultGetInstanceTypes&#46;instanceTypes[instanceTypeCountSize - 1].instanceType),
     *     paymentType: "PayAsYouGo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecp.get_zones()
     * default_get_instance_types = alicloud.ecp.get_instance_types()
     * count_size = len(default.zones)
     * zone_id = default.zones[count_size - 1].zone_id
     * instance_type_count_size = len(default_get_instance_types.instance_types)
     * instance_type = default_get_instance_types.instance_types[instance_type_count_size - 1].instance_type
     * default_get_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
     * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
     *     zone_id=zone_id)
     * group = alicloud.ecs.SecurityGroup("group",
     *     name=name,
     *     vpc_id=default_get_networks.ids[0])
     * default_key_pair = alicloud.ecp.KeyPair("default",
     *     key_pair_name=name,
     *     public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
     * default_instance = alicloud.ecp.Instance("default",
     *     instance_name=name,
     *     description=name,
     *     force=True,
     *     key_pair_name=default_key_pair.key_pair_name,
     *     vswitch_id=default_get_switches.ids[0],
     *     image_id="android_9_0_0_release_2851157_20211201.vhd",
     *     instance_type=default_get_instance_types.instance_types[instance_type_count_size - 1].instance_type,
     *     payment_type="PayAsYouGo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecp.GetZones.Invoke();
     *     var defaultGetInstanceTypes = AliCloud.Ecp.GetInstanceTypes.Invoke();
     *     var countSize = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length;
     *     var zoneId = Output.Tuple(@default, countSize).Apply(values =>
     *     {
     *         var @default = values.Item1;
     *         var countSize = values.Item2;
     *         return @default.Apply(getZonesResult => getZonesResult.Zones)[countSize - 1].ZoneId;
     *     });
     *     var instanceTypeCountSize = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes).Length;
     *     var instanceType = Output.Tuple(defaultGetInstanceTypes, instanceTypeCountSize).Apply(values =>
     *     {
     *         var defaultGetInstanceTypes = values.Item1;
     *         var instanceTypeCountSize = values.Item2;
     *         return defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes)[instanceTypeCountSize - 1].InstanceType;
     *     });
     *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
     *     {
     *         NameRegex = "default-NODELETING",
     *     });
     *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
     *     {
     *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *         ZoneId = zoneId,
     *     });
     *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
     *     {
     *         Name = name,
     *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *     });
     *     var defaultKeyPair = new AliCloud.Ecp.KeyPair("default", new()
     *     {
     *         KeyPairName = name,
     *         PublicKeyBody = "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
     *     });
     *     var defaultInstance = new AliCloud.Ecp.Instance("default", new()
     *     {
     *         InstanceName = name,
     *         Description = name,
     *         Force = true,
     *         KeyPairName = defaultKeyPair.KeyPairName,
     *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
     *         ImageId = "android_9_0_0_release_2851157_20211201.vhd",
     *         InstanceType = Output.Tuple(defaultGetInstanceTypes, instanceTypeCountSize).Apply(values =>
     *         {
     *             var defaultGetInstanceTypes = values.Item1;
     *             var instanceTypeCountSize = values.Item2;
     *             return defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes)[instanceTypeCountSize - 1].InstanceType;
     *         }),
     *         PaymentType = "PayAsYouGo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecp"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ecp.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetInstanceTypes, err := ecp.GetInstanceTypes(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		countSize := len(_default.Zones)
     * 		zoneId := _default.Zones[countSize-1].ZoneId
     * 		instanceTypeCountSize := len(defaultGetInstanceTypes.InstanceTypes)
     * 		_ := defaultGetInstanceTypes.InstanceTypes[instanceTypeCountSize-1].InstanceType
     * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
     * 			NameRegex: pulumi.StringRef("default-NODELETING"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
     * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
     * 			ZoneId: pulumi.StringRef(zoneId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
     * 			Name:  pulumi.Any(name),
     * 			VpcId: pulumi.String(defaultGetNetworks.Ids[0]),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultKeyPair, err := ecp.NewKeyPair(ctx, "default", &ecp.KeyPairArgs{
     * 			KeyPairName:   pulumi.Any(name),
     * 			PublicKeyBody: pulumi.String("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ecp.NewInstance(ctx, "default", &ecp.InstanceArgs{
     * 			InstanceName: pulumi.Any(name),
     * 			Description:  pulumi.Any(name),
     * 			Force:        pulumi.Bool(true),
     * 			KeyPairName:  defaultKeyPair.KeyPairName,
     * 			VswitchId:    pulumi.String(defaultGetSwitches.Ids[0]),
     * 			ImageId:      pulumi.String("android_9_0_0_release_2851157_20211201.vhd"),
     * 			InstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[instanceTypeCountSize-1].InstanceType),
     * 			PaymentType:  pulumi.String("PayAsYouGo"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecp.EcpFunctions;
     * import com.pulumi.alicloud.ecp.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.ecp.inputs.GetInstanceTypesArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
     * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
     * import com.pulumi.alicloud.ecs.SecurityGroup;
     * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
     * import com.pulumi.alicloud.ecp.KeyPair;
     * import com.pulumi.alicloud.ecp.KeyPairArgs;
     * import com.pulumi.alicloud.ecp.Instance;
     * import com.pulumi.alicloud.ecp.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcpFunctions.getZones();
     *         final var defaultGetInstanceTypes = EcpFunctions.getInstanceTypes();
     *         final var countSize = default_.zones().length();
     *         final var zoneId = default_.zones()[countSize - 1].zoneId();
     *         final var instanceTypeCountSize = defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()).length();
     *         final var instanceType = defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes())[instanceTypeCountSize - 1].instanceType();
     *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
     *             .nameRegex("default-NODELETING")
     *             .build());
     *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
     *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
     *             .zoneId(zoneId)
     *             .build());
     *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
     *             .name(name)
     *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
     *             .build());
     *         var defaultKeyPair = new KeyPair("defaultKeyPair", KeyPairArgs.builder()
     *             .keyPairName(name)
     *             .publicKeyBody("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
     *             .build());
     *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
     *             .instanceName(name)
     *             .description(name)
     *             .force("true")
     *             .keyPairName(defaultKeyPair.keyPairName())
     *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
     *             .imageId("android_9_0_0_release_2851157_20211201.vhd")
     *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes())[instanceTypeCountSize - 1].instanceType())
     *             .paymentType("PayAsYouGo")
     *             .build());
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param enableDetails
     * @param ids A list of Ecp Instances IDs.
     * @param imageId The ID Of The Image.
     * @param instanceName The name of the instance. It must be 2 to 128 characters in length and must start with an
     * uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
     * half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
     * the instance.
     * @param instanceType Instance Type.
     * @param keyPairName The name of the key pair of the mobile phone instance.
     * @param nameRegex A regex string to filter results by mobile phone name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param paymentType The payment type.Valid values: `PayAsYouGo`,`Subscription`
     * @param resolution The selected resolution for the cloud mobile phone instance.
     * @param status Instance status. Valid values: `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`
     * .
     * @param zoneId
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        imageId: String? = null,
        instanceName: String? = null,
        instanceType: String? = null,
        keyPairName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        paymentType: String? = null,
        resolution: String? = null,
        status: String? = null,
        zoneId: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            imageId = imageId,
            instanceName = instanceName,
            instanceType = instanceType,
            keyPairName = keyPairName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            paymentType = paymentType,
            resolution = resolution,
            status = status,
            zoneId = zoneId,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecp&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecp Key Pairs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.130.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecp.getKeyPairs({});
     * export const ecpKeyPairId1 = ids.then(ids => ids.pairs?.[0]?.id);
     * const nameRegex = alicloud.ecp.getKeyPairs({
     *     nameRegex: "^my-KeyPair",
     * });
     * export const ecpKeyPairId2 = nameRegex.then(nameRegex => nameRegex.pairs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecp.get_key_pairs()
     * pulumi.export("ecpKeyPairId1", ids.pairs[0].id)
     * name_regex = alicloud.ecp.get_key_pairs(name_regex="^my-KeyPair")
     * pulumi.export("ecpKeyPairId2", name_regex.pairs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecp.GetKeyPairs.Invoke();
     *     var nameRegex = AliCloud.Ecp.GetKeyPairs.Invoke(new()
     *     {
     *         NameRegex = "^my-KeyPair",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecpKeyPairId1"] = ids&#46;Apply(getKeyPairsResult => getKeyPairsResult&#46;Pairs[0]?.Id),
     *         ["ecpKeyPairId2"] = nameRegex&#46;Apply(getKeyPairsResult => getKeyPairsResult&#46;Pairs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecp.GetKeyPairs(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecpKeyPairId1", ids.Pairs[0].Id)
     * 		nameRegex, err := ecp.GetKeyPairs(ctx, &ecp.GetKeyPairsArgs{
     * 			NameRegex: pulumi.StringRef("^my-KeyPair"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecpKeyPairId2", nameRegex.Pairs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecp.EcpFunctions;
     * import com.pulumi.alicloud.ecp.inputs.GetKeyPairsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcpFunctions.getKeyPairs();
     *         ctx.export("ecpKeyPairId1", ids.applyValue(getKeyPairsResult -> getKeyPairsResult.pairs()[0].id()));
     *         final var nameRegex = EcpFunctions.getKeyPairs(GetKeyPairsArgs.builder()
     *             .nameRegex("^my-KeyPair")
     *             .build());
     *         ctx.export("ecpKeyPairId2", nameRegex.applyValue(getKeyPairsResult -> getKeyPairsResult.pairs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecp:getKeyPairs
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ecp:getKeyPairs
     *       Arguments:
     *         nameRegex: ^my-KeyPair
     * outputs:
     *   ecpKeyPairId1: ${ids.pairs[0].id}
     *   ecpKeyPairId2: ${nameRegex.pairs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKeyPairs.
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(argument: GetKeyPairsPlainArgs): GetKeyPairsResult =
        getKeyPairsResultToKotlin(getKeyPairsPlain(argument.toJava()).await())

    /**
     * @see [getKeyPairs].
     * @param ids A list of Key Pair IDs. Its element value is same as Key Pair Name.
     * @param keyPairFingerPrint The Private Key of the Fingerprint.
     * @param nameRegex A regex string to filter results by Key Pair name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(
        ids: List<String>? = null,
        keyPairFingerPrint: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetKeyPairsResult {
        val argument = GetKeyPairsPlainArgs(
            ids = ids,
            keyPairFingerPrint = keyPairFingerPrint,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getKeyPairsResultToKotlin(getKeyPairsPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyPairs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecp&#46;kotlin&#46;inputs&#46;GetKeyPairsPlainArgs].
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(argument: suspend GetKeyPairsPlainArgsBuilder.() -> Unit): GetKeyPairsResult {
        val builder = GetKeyPairsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyPairsResultToKotlin(getKeyPairsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the available zones with the Cloud Phone (ECP) Instance of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.158.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecp.getZones({});
     * export const alicloudNasZonesId = _default.then(_default => _default.zones?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecp.get_zones()
     * pulumi.export("alicloudNasZonesId", default.zones[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecp.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudNasZonesId"] = @default&#46;Apply(@default => @default&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.ZoneId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ecp.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudNasZonesId", _default.Zones[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecp.EcpFunctions;
     * import com.pulumi.alicloud.ecp.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcpFunctions.getZones();
     *         ctx.export("alicloudNasZonesId", default_.zones()[0].zoneId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecp:getZones
     *       Arguments: {}
     * outputs:
     *   alicloudNasZonesId: ${default.zones[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecp&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
