@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin

import com.pulumi.alicloud.ecp.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Elastic Cloud Phone (ECP) Instance resource.
 * For information about Elastic Cloud Phone (ECP) Instance and how to use it,
 * see [What is Instance](https://www.alibabacloud.com/help/en/cloudphone/latest/api-cloudphone-2020-12-30-runinstances).
 * > **NOTE:** Available since v1.158.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.ecp.getZones({});
 * const defaultGetInstanceTypes = alicloud.ecp.getInstanceTypes({});
 * const countSize = _default.then(_default => _default.zones).length;
 * const zoneId = Promise.all([_default, countSize])&#46;then(([_default, countSize]) => _default&#46;zones[countSize - 1].zoneId);
 * const instanceTypeCountSize = defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes).length;
 * const instanceType = Promise.all([defaultGetInstanceTypes, instanceTypeCountSize])&#46;then(([defaultGetInstanceTypes, instanceTypeCountSize]) => defaultGetInstanceTypes&#46;instanceTypes[instanceTypeCountSize - 1].instanceType);
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = defaultGetNetworks.then(defaultGetNetworks => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: zoneId,
 * }));
 * const group = new alicloud.ecs.SecurityGroup("group", {
 *     name: name,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 * });
 * const defaultKeyPair = new alicloud.ecp.KeyPair("default", {
 *     keyPairName: `${name}-${defaultInteger.result}`,
 *     publicKeyBody: "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 * });
 * const defaultInstance = new alicloud.ecp.Instance("default", {
 *     instanceName: name,
 *     description: name,
 *     keyPairName: defaultKeyPair.keyPairName,
 *     securityGroupId: group.id,
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     imageId: "android_9_0_0_release_2851157_20211201.vhd",
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[1]?.instanceType),
 *     vncPassword: "Ecp123",
 *     paymentType: "PayAsYouGo",
 *     force: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.ecp.get_zones()
 * default_get_instance_types = alicloud.ecp.get_instance_types()
 * count_size = len(default.zones)
 * zone_id = default.zones[count_size - 1].zone_id
 * instance_type_count_size = len(default_get_instance_types.instance_types)
 * instance_type = default_get_instance_types.instance_types[instance_type_count_size - 1].instance_type
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=zone_id)
 * group = alicloud.ecs.SecurityGroup("group",
 *     name=name,
 *     vpc_id=default_get_networks.ids[0])
 * default_key_pair = alicloud.ecp.KeyPair("default",
 *     key_pair_name=f"{name}-{default_integer['result']}",
 *     public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 * default_instance = alicloud.ecp.Instance("default",
 *     instance_name=name,
 *     description=name,
 *     key_pair_name=default_key_pair.key_pair_name,
 *     security_group_id=group.id,
 *     vswitch_id=default_get_switches.ids[0],
 *     image_id="android_9_0_0_release_2851157_20211201.vhd",
 *     instance_type=default_get_instance_types.instance_types[1].instance_type,
 *     vnc_password="Ecp123",
 *     payment_type="PayAsYouGo",
 *     force=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.Ecp.GetZones.Invoke();
 *     var defaultGetInstanceTypes = AliCloud.Ecp.GetInstanceTypes.Invoke();
 *     var countSize = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length;
 *     var zoneId = Output.Tuple(@default, countSize).Apply(values =>
 *     {
 *         var @default = values.Item1;
 *         var countSize = values.Item2;
 *         return @default.Apply(getZonesResult => getZonesResult.Zones)[countSize - 1].ZoneId;
 *     });
 *     var instanceTypeCountSize = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes).Length;
 *     var instanceType = Output.Tuple(defaultGetInstanceTypes, instanceTypeCountSize).Apply(values =>
 *     {
 *         var defaultGetInstanceTypes = values.Item1;
 *         var instanceTypeCountSize = values.Item2;
 *         return defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes)[instanceTypeCountSize - 1].InstanceType;
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = zoneId,
 *     });
 *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
 *     {
 *         Name = name,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *     });
 *     var defaultKeyPair = new AliCloud.Ecp.KeyPair("default", new()
 *     {
 *         KeyPairName = $"{name}-{defaultInteger.Result}",
 *         PublicKeyBody = "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 *     });
 *     var defaultInstance = new AliCloud.Ecp.Instance("default", new()
 *     {
 *         InstanceName = name,
 *         Description = name,
 *         KeyPairName = defaultKeyPair.KeyPairName,
 *         SecurityGroupId = @group.Id,
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         ImageId = "android_9_0_0_release_2851157_20211201.vhd",
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[1]?.InstanceType),
 *         VncPassword = "Ecp123",
 *         PaymentType = "PayAsYouGo",
 *         Force = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecp"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := ecp.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecp.GetInstanceTypes(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		countSize := len(_default.Zones)
 * 		zoneId := _default.Zones[countSize-1].ZoneId
 * 		instanceTypeCountSize := len(defaultGetInstanceTypes.InstanceTypes)
 * 		_ := defaultGetInstanceTypes.InstanceTypes[instanceTypeCountSize-1].InstanceType
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(zoneId),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		group, err := ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: pulumi.String(defaultGetNetworks.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultKeyPair, err := ecp.NewKeyPair(ctx, "default", &ecp.KeyPairArgs{
 * 			KeyPairName:   pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			PublicKeyBody: pulumi.String("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecp.NewInstance(ctx, "default", &ecp.InstanceArgs{
 * 			InstanceName:    pulumi.String(name),
 * 			Description:     pulumi.String(name),
 * 			KeyPairName:     defaultKeyPair.KeyPairName,
 * 			SecurityGroupId: group.ID(),
 * 			VswitchId:       pulumi.String(defaultGetSwitches.Ids[0]),
 * 			ImageId:         pulumi.String("android_9_0_0_release_2851157_20211201.vhd"),
 * 			InstanceType:    pulumi.String(defaultGetInstanceTypes.InstanceTypes[1].InstanceType),
 * 			VncPassword:     pulumi.String("Ecp123"),
 * 			PaymentType:     pulumi.String("PayAsYouGo"),
 * 			Force:           pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ecp.EcpFunctions;
 * import com.pulumi.alicloud.ecp.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecp.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecp.KeyPair;
 * import com.pulumi.alicloud.ecp.KeyPairArgs;
 * import com.pulumi.alicloud.ecp.Instance;
 * import com.pulumi.alicloud.ecp.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = EcpFunctions.getZones();
 *         final var defaultGetInstanceTypes = EcpFunctions.getInstanceTypes();
 *         final var countSize = default_.zones().length();
 *         final var zoneId = default_.zones()[countSize - 1].zoneId();
 *         final var instanceTypeCountSize = defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()).length();
 *         final var instanceType = defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes())[instanceTypeCountSize - 1].instanceType();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(zoneId)
 *             .build());
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .build());
 *         var defaultKeyPair = new KeyPair("defaultKeyPair", KeyPairArgs.builder()
 *             .keyPairName(String.format("%s-%s", name,defaultInteger.result()))
 *             .publicKeyBody("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .instanceName(name)
 *             .description(name)
 *             .keyPairName(defaultKeyPair.keyPairName())
 *             .securityGroupId(group.id())
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .imageId("android_9_0_0_release_2851157_20211201.vhd")
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[1].instanceType()))
 *             .vncPassword("Ecp123")
 *             .paymentType("PayAsYouGo")
 *             .force("true")
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Elastic Cloud Phone (ECP) Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecp/instance:Instance example <id>
 * ```
 * @property autoPay The auto pay.
 * @property autoRenew The auto renew.
 * @property description Description of the instance. 2 to 256 English or Chinese characters in length and cannot
 * start with `http://` and `https`.
 * @property eipBandwidth The eip bandwidth.
 * @property force The force.
 * @property imageId The ID Of The Image.
 * @property instanceName The name of the instance. It must be 2 to 128 characters in length and must start with an
 * uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
 * half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
 * the instance.
 * @property instanceType Instance Type.
 * @property keyPairName The name of the key pair of the mobile phone instance.
 * @property paymentType The payment type.Valid values: `PayAsYouGo`,`Subscription`
 * @property period The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
 * is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
 * @property periodUnit The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
 * to `Month`.
 * @property resolution The selected resolution for the cloud mobile phone instance.
 * @property securityGroupId The ID of the security group. The security group is the same as that of the
 * ECS instance.
 * @property status Instance status. Valid values: `Running`, `Stopped`.
 * @property vncPassword Cloud mobile phone VNC password. The password must be six characters in length and must
 * contain only uppercase, lowercase English letters and Arabic numerals.
 * @property vswitchId The vswitch id.
 */
public data class InstanceArgs(
    public val autoPay: Output<Boolean>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val eipBandwidth: Output<Int>? = null,
    public val force: Output<Boolean>? = null,
    public val imageId: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val periodUnit: Output<String>? = null,
    public val resolution: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val vncPassword: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecp.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ecp.InstanceArgs =
        com.pulumi.alicloud.ecp.InstanceArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .eipBandwidth(eipBandwidth?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .resolution(resolution?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vncPassword(vncPassword?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoPay: Output<Boolean>? = null

    private var autoRenew: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var eipBandwidth: Output<Int>? = null

    private var force: Output<Boolean>? = null

    private var imageId: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var periodUnit: Output<String>? = null

    private var resolution: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var status: Output<String>? = null

    private var vncPassword: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The auto pay.
     */
    @JvmName("gncdeqrhgwveyhew")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value The auto renew.
     */
    @JvmName("wrmxmlkxlhhlhfpx")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Description of the instance. 2 to 256 English or Chinese characters in length and cannot
     * start with `http://` and `https`.
     */
    @JvmName("rkudshrqqtmhsiex")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The eip bandwidth.
     */
    @JvmName("blfbkmeqsgnvpvdy")
    public suspend fun eipBandwidth(`value`: Output<Int>) {
        this.eipBandwidth = value
    }

    /**
     * @param value The force.
     */
    @JvmName("psnkwsxgyowevknr")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value The ID Of The Image.
     */
    @JvmName("byebasctqfajyeso")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The name of the instance. It must be 2 to 128 characters in length and must start with an
     * uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
     * half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
     * the instance.
     */
    @JvmName("urddymxlhokkoxos")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Instance Type.
     */
    @JvmName("fghvwcmxvmlanwyp")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The name of the key pair of the mobile phone instance.
     */
    @JvmName("tfyavedxgcwutwws")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The payment type.Valid values: `PayAsYouGo`,`Subscription`
     */
    @JvmName("ducisfarpfjpadig")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
     * is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
     */
    @JvmName("siusolsgbgvtvesg")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
     * to `Month`.
     */
    @JvmName("dtkqvvrlklkqxhds")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The selected resolution for the cloud mobile phone instance.
     */
    @JvmName("mkovdluqvspdvtqb")
    public suspend fun resolution(`value`: Output<String>) {
        this.resolution = value
    }

    /**
     * @param value The ID of the security group. The security group is the same as that of the
     * ECS instance.
     */
    @JvmName("amndvmujaxettsec")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Instance status. Valid values: `Running`, `Stopped`.
     */
    @JvmName("mmppvrxpyjhnokuu")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Cloud mobile phone VNC password. The password must be six characters in length and must
     * contain only uppercase, lowercase English letters and Arabic numerals.
     */
    @JvmName("fbilreluhxiwblmi")
    public suspend fun vncPassword(`value`: Output<String>) {
        this.vncPassword = value
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("rhlfiwcsuyshrjtp")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The auto pay.
     */
    @JvmName("cjfwisxremuucygq")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value The auto renew.
     */
    @JvmName("jhynkaorubguycit")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Description of the instance. 2 to 256 English or Chinese characters in length and cannot
     * start with `http://` and `https`.
     */
    @JvmName("wgjwhdskfixmdgyy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The eip bandwidth.
     */
    @JvmName("ikhdcqqugaefqdhf")
    public suspend fun eipBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipBandwidth = mapped
    }

    /**
     * @param value The force.
     */
    @JvmName("vqnwyoqqjmirrmcq")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value The ID Of The Image.
     */
    @JvmName("eqonrxkpbftmqgvu")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The name of the instance. It must be 2 to 128 characters in length and must start with an
     * uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
     * half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
     * the instance.
     */
    @JvmName("qspckutykurgsrde")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Instance Type.
     */
    @JvmName("bmwffwqtwnrhegyk")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The name of the key pair of the mobile phone instance.
     */
    @JvmName("bsipvfxdbnxqyxid")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The payment type.Valid values: `PayAsYouGo`,`Subscription`
     */
    @JvmName("gihubcgibtixqyrw")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The period. It is valid when `period_unit` is 'Year'. Valid value: `1`, `2`, `3`, `4`, `5`. It
     * is valid when `period_unit` is 'Month'. Valid value: `1`, `2`, `3`, `5`
     */
    @JvmName("cvgsxxinlcgsevla")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The duration unit that you will buy the resource. Valid value: `Year`,`Month`. Default
     * to `Month`.
     */
    @JvmName("xclqquiiccqvcnov")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The selected resolution for the cloud mobile phone instance.
     */
    @JvmName("lbnbwdimrvwyhsbi")
    public suspend fun resolution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolution = mapped
    }

    /**
     * @param value The ID of the security group. The security group is the same as that of the
     * ECS instance.
     */
    @JvmName("bpyvruqnusmeyvfc")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Instance status. Valid values: `Running`, `Stopped`.
     */
    @JvmName("kuoktcwsgxkgklmv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Cloud mobile phone VNC password. The password must be six characters in length and must
     * contain only uppercase, lowercase English letters and Arabic numerals.
     */
    @JvmName("enrqrioexiuagvnv")
    public suspend fun vncPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vncPassword = mapped
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("mkhqusqktesyuvxa")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoPay = autoPay,
        autoRenew = autoRenew,
        description = description,
        eipBandwidth = eipBandwidth,
        force = force,
        imageId = imageId,
        instanceName = instanceName,
        instanceType = instanceType,
        keyPairName = keyPairName,
        paymentType = paymentType,
        period = period,
        periodUnit = periodUnit,
        resolution = resolution,
        securityGroupId = securityGroupId,
        status = status,
        vncPassword = vncPassword,
        vswitchId = vswitchId,
    )
}
