@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeyPair].
 */
@PulumiTagMarker
public class KeyPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyPairArgs = KeyPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyPairArgsBuilder.() -> Unit) {
        val builder = KeyPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyPair {
        val builtJavaResource = com.pulumi.alicloud.ecp.KeyPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyPair(builtJavaResource)
    }
}

/**
 * Provides a Elastic Cloud Phone (ECP) Key Pair resource.
 * For information about Elastic Cloud Phone (ECP) Key Pair and how to use it, see [What is Key Pair](https://help.aliyun.com/document_detail/257197.html).
 * > **NOTE:** Available in v1.130.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecp.KeyPair("example", {
 *     keyPairName: "my-KeyPair",
 *     publicKeyBody: "ssh-rsa AAAAxxxxxxxxxxtyuudsfsg",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecp.KeyPair("example",
 *     key_pair_name="my-KeyPair",
 *     public_key_body="ssh-rsa AAAAxxxxxxxxxxtyuudsfsg")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecp.KeyPair("example", new()
 *     {
 *         KeyPairName = "my-KeyPair",
 *         PublicKeyBody = "ssh-rsa AAAAxxxxxxxxxxtyuudsfsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecp.NewKeyPair(ctx, "example", &ecp.KeyPairArgs{
 * 			KeyPairName:   pulumi.String("my-KeyPair"),
 * 			PublicKeyBody: pulumi.String("ssh-rsa AAAAxxxxxxxxxxtyuudsfsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecp.KeyPair;
 * import com.pulumi.alicloud.ecp.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KeyPair("example", KeyPairArgs.builder()
 *             .keyPairName("my-KeyPair")
 *             .publicKeyBody("ssh-rsa AAAAxxxxxxxxxxtyuudsfsg")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecp:KeyPair
 *     properties:
 *       keyPairName: my-KeyPair
 *       publicKeyBody: ssh-rsa AAAAxxxxxxxxxxtyuudsfsg
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Elastic Cloud Phone (ECP) Key Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecp/keyPair:KeyPair example <key_pair_name>
 * ```
 */
public class KeyPair internal constructor(
    override val javaResource: com.pulumi.alicloud.ecp.KeyPair,
) : KotlinCustomResource(javaResource, KeyPairMapper) {
    /**
     * The Key Name.
     */
    public val keyPairName: Output<String>
        get() = javaResource.keyPairName().applyValue({ args0 -> args0 })

    /**
     * The public key body.
     */
    public val publicKeyBody: Output<String>
        get() = javaResource.publicKeyBody().applyValue({ args0 -> args0 })
}

public object KeyPairMapper : ResourceMapper<KeyPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecp.KeyPair::class == javaResource::class

    override fun map(javaResource: Resource): KeyPair = KeyPair(
        javaResource as
            com.pulumi.alicloud.ecp.KeyPair,
    )
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyPair].
 */
public suspend fun keyPair(name: String, block: suspend KeyPairResourceBuilder.() -> Unit): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyPair(name: String): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
