@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin

import com.pulumi.alicloud.ecp.KeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Elastic Cloud Phone (ECP) Key Pair resource.
 * For information about Elastic Cloud Phone (ECP) Key Pair and how to use it, see [What is Key Pair](https://help.aliyun.com/document_detail/257197.html).
 * > **NOTE:** Available in v1.130.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecp.KeyPair("example", {
 *     keyPairName: "my-KeyPair",
 *     publicKeyBody: "ssh-rsa AAAAxxxxxxxxxxtyuudsfsg",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecp.KeyPair("example",
 *     key_pair_name="my-KeyPair",
 *     public_key_body="ssh-rsa AAAAxxxxxxxxxxtyuudsfsg")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecp.KeyPair("example", new()
 *     {
 *         KeyPairName = "my-KeyPair",
 *         PublicKeyBody = "ssh-rsa AAAAxxxxxxxxxxtyuudsfsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecp.NewKeyPair(ctx, "example", &ecp.KeyPairArgs{
 * 			KeyPairName:   pulumi.String("my-KeyPair"),
 * 			PublicKeyBody: pulumi.String("ssh-rsa AAAAxxxxxxxxxxtyuudsfsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecp.KeyPair;
 * import com.pulumi.alicloud.ecp.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KeyPair("example", KeyPairArgs.builder()
 *             .keyPairName("my-KeyPair")
 *             .publicKeyBody("ssh-rsa AAAAxxxxxxxxxxtyuudsfsg")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecp:KeyPair
 *     properties:
 *       keyPairName: my-KeyPair
 *       publicKeyBody: ssh-rsa AAAAxxxxxxxxxxtyuudsfsg
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Elastic Cloud Phone (ECP) Key Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecp/keyPair:KeyPair example <key_pair_name>
 * ```
 * @property keyPairName The Key Name.
 * @property publicKeyBody The public key body.
 */
public data class KeyPairArgs(
    public val keyPairName: Output<String>? = null,
    public val publicKeyBody: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecp.KeyPairArgs> {
    override fun toJava(): com.pulumi.alicloud.ecp.KeyPairArgs =
        com.pulumi.alicloud.ecp.KeyPairArgs.builder()
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .publicKeyBody(publicKeyBody?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyPairArgs].
 */
@PulumiTagMarker
public class KeyPairArgsBuilder internal constructor() {
    private var keyPairName: Output<String>? = null

    private var publicKeyBody: Output<String>? = null

    /**
     * @param value The Key Name.
     */
    @JvmName("yfgegkadyvjpahag")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The public key body.
     */
    @JvmName("ydufawtbaxhgfqhj")
    public suspend fun publicKeyBody(`value`: Output<String>) {
        this.publicKeyBody = value
    }

    /**
     * @param value The Key Name.
     */
    @JvmName("chnumtopdvprdgdk")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The public key body.
     */
    @JvmName("pxgvesodyfyfbong")
    public suspend fun publicKeyBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeyBody = mapped
    }

    internal fun build(): KeyPairArgs = KeyPairArgs(
        keyPairName = keyPairName,
        publicKeyBody = publicKeyBody,
    )
}
