@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.inputs

import com.pulumi.alicloud.ecp.inputs.GetInstanceTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypes.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetInstanceTypesPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecp.inputs.GetInstanceTypesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecp.inputs.GetInstanceTypesPlainArgs =
        com.pulumi.alicloud.ecp.inputs.GetInstanceTypesPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pormuekwxvfseuij")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetInstanceTypesPlainArgs = GetInstanceTypesPlainArgs(
        outputFile = outputFile,
    )
}
