@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.inputs

import com.pulumi.alicloud.ecp.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property enableDetails
 * @property ids A list of Ecp Instances IDs.
 * @property imageId The ID Of The Image.
 * @property instanceName The name of the instance. It must be 2 to 128 characters in length and must start with an
 * uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
 * half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
 * the instance.
 * @property instanceType Instance Type.
 * @property keyPairName The name of the key pair of the mobile phone instance.
 * @property nameRegex A regex string to filter results by mobile phone name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property paymentType The payment type.Valid values: `PayAsYouGo`,`Subscription`
 * @property resolution The selected resolution for the cloud mobile phone instance.
 * @property status Instance status. Valid values: `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`
 * .
 * @property zoneId
 */
public data class GetInstancesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val imageId: String? = null,
    public val instanceName: String? = null,
    public val instanceType: String? = null,
    public val keyPairName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val resolution: String? = null,
    public val status: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecp.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecp.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.ecp.inputs.GetInstancesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .imageId(imageId?.let({ args0 -> args0 }))
            .instanceName(instanceName?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .keyPairName(keyPairName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .resolution(resolution?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var imageId: String? = null

    private var instanceName: String? = null

    private var instanceType: String? = null

    private var keyPairName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var paymentType: String? = null

    private var resolution: String? = null

    private var status: String? = null

    private var zoneId: String? = null

    /**
     * @param value
     */
    @JvmName("trsxeyfqpqhiibxp")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Ecp Instances IDs.
     */
    @JvmName("kglurwsutuvjetgi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ecp Instances IDs.
     */
    @JvmName("oaypkllmwjpdouym")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID Of The Image.
     */
    @JvmName("wvfinljhgiciqqia")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageId = mapped
    }

    /**
     * @param value The name of the instance. It must be 2 to 128 characters in length and must start with an
     * uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
     * half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
     * the instance.
     */
    @JvmName("joafgqdlsayisxbt")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value Instance Type.
     */
    @JvmName("faowqivvavkwemom")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value The name of the key pair of the mobile phone instance.
     */
    @JvmName("qrykevguxrokmmjm")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyPairName = mapped
    }

    /**
     * @param value A regex string to filter results by mobile phone name.
     */
    @JvmName("dapddmjxrxirdqax")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("txlyvitkcteqnekc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The payment type.Valid values: `PayAsYouGo`,`Subscription`
     */
    @JvmName("eehltdabrskikgor")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value The selected resolution for the cloud mobile phone instance.
     */
    @JvmName("kffgbtpgjajsqywa")
    public suspend fun resolution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resolution = mapped
    }

    /**
     * @param value Instance status. Valid values: `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`
     * .
     */
    @JvmName("aieegbxrpfymtecd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("iqwcycxttaippnuy")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        imageId = imageId,
        instanceName = instanceName,
        instanceType = instanceType,
        keyPairName = keyPairName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        paymentType = paymentType,
        resolution = resolution,
        status = status,
        zoneId = zoneId,
    )
}
