@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.inputs

import com.pulumi.alicloud.ecp.inputs.GetKeyPairsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKeyPairs.
 * @property ids A list of Key Pair IDs. Its element value is same as Key Pair Name.
 * @property keyPairFingerPrint The Private Key of the Fingerprint.
 * @property nameRegex A regex string to filter results by Key Pair name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetKeyPairsPlainArgs(
    public val ids: List<String>? = null,
    public val keyPairFingerPrint: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecp.inputs.GetKeyPairsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecp.inputs.GetKeyPairsPlainArgs =
        com.pulumi.alicloud.ecp.inputs.GetKeyPairsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyPairFingerPrint(keyPairFingerPrint?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeyPairsPlainArgs].
 */
@PulumiTagMarker
public class GetKeyPairsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyPairFingerPrint: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Key Pair IDs. Its element value is same as Key Pair Name.
     */
    @JvmName("xddvhqoihuvroyqk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Key Pair IDs. Its element value is same as Key Pair Name.
     */
    @JvmName("bqclughdwhmvnjjs")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The Private Key of the Fingerprint.
     */
    @JvmName("apeegpgqmyrrxxrl")
    public suspend fun keyPairFingerPrint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyPairFingerPrint = mapped
    }

    /**
     * @param value A regex string to filter results by Key Pair name.
     */
    @JvmName("skmgavqtatfescqp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("glmijfgcmxmvbtay")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetKeyPairsPlainArgs = GetKeyPairsPlainArgs(
        ids = ids,
        keyPairFingerPrint = keyPairFingerPrint,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
