@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpuCoreCount The cpu core count of the current instance type.
 * @property defaultResolution The default resolution of the current instance type.
 * @property instanceType The list of available instance type.
 * @property instanceTypeFamily
 * @property name The name of the current instance type.
 * @property nameEn The English name of the current instance type.
 */
public data class GetInstanceTypesInstanceType(
    public val cpuCoreCount: Int,
    public val defaultResolution: String,
    public val instanceType: String,
    public val instanceTypeFamily: String,
    public val name: String,
    public val nameEn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecp.outputs.GetInstanceTypesInstanceType): GetInstanceTypesInstanceType = GetInstanceTypesInstanceType(
            cpuCoreCount = javaType.cpuCoreCount(),
            defaultResolution = javaType.defaultResolution(),
            instanceType = javaType.instanceType(),
            instanceTypeFamily = javaType.instanceTypeFamily(),
            name = javaType.name(),
            nameEn = javaType.nameEn(),
        )
    }
}
