@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypes.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceTypes
 * @property outputFile
 */
public data class GetInstanceTypesResult(
    public val id: String,
    public val instanceTypes: List<GetInstanceTypesInstanceType>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecp.outputs.GetInstanceTypesResult): GetInstanceTypesResult = GetInstanceTypesResult(
            id = javaType.id(),
            instanceTypes = javaType.instanceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecp.kotlin.outputs.GetInstanceTypesInstanceType.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
