@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Instance Description.
 * @property id The ID of the Instance.
 * @property imageId The ID Of The Image.
 * @property instanceId InstanceId.
 * @property instanceName Instance Name.
 * @property instanceType Instance Type.
 * @property keyPairName The Key Name.
 * @property paymentType The payment type.Valid values: `PayAsYouGo`,`Subscription`
 * @property resolution Resolution.
 * @property securityGroupId Security Group ID.
 * @property status Instance Status.
 * @property vncUrl VNC login address.
 * @property vswitchId The vswitch id.
 * @property zoneId
 */
public data class GetInstancesInstance(
    public val description: String,
    public val id: String,
    public val imageId: String,
    public val instanceId: String,
    public val instanceName: String,
    public val instanceType: String,
    public val keyPairName: String,
    public val paymentType: String,
    public val resolution: String,
    public val securityGroupId: String,
    public val status: String,
    public val vncUrl: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecp.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            description = javaType.description(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            instanceType = javaType.instanceType(),
            keyPairName = javaType.keyPairName(),
            paymentType = javaType.paymentType(),
            resolution = javaType.resolution(),
            securityGroupId = javaType.securityGroupId(),
            status = javaType.status(),
            vncUrl = javaType.vncUrl(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
