@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstances.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property imageId
 * @property instanceName
 * @property instanceType
 * @property instances
 * @property keyPairName
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property paymentType
 * @property resolution
 * @property status
 * @property zoneId
 */
public data class GetInstancesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val imageId: String? = null,
    public val instanceName: String? = null,
    public val instanceType: String? = null,
    public val instances: List<GetInstancesInstance>,
    public val keyPairName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val resolution: String? = null,
    public val status: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecp.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            imageId = javaType.imageId().map({ args0 -> args0 }).orElse(null),
            instanceName = javaType.instanceName().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecp.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            keyPairName = javaType.keyPairName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            resolution = javaType.resolution().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
