@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Key Pair. Its value is same as Queue Name.
 * @property keyPairFingerPrint The Private Key of the Fingerprint.
 * @property keyPairName The Key Name.
 */
public data class GetKeyPairsPair(
    public val id: String,
    public val keyPairFingerPrint: String,
    public val keyPairName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecp.outputs.GetKeyPairsPair): GetKeyPairsPair = GetKeyPairsPair(
            id = javaType.id(),
            keyPairFingerPrint = javaType.keyPairFingerPrint(),
            keyPairName = javaType.keyPairName(),
        )
    }
}
