@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKeyPairs.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyPairFingerPrint
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pairs
 */
public data class GetKeyPairsResult(
    public val id: String,
    public val ids: List<String>,
    public val keyPairFingerPrint: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pairs: List<GetKeyPairsPair>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecp.outputs.GetKeyPairsResult): GetKeyPairsResult = GetKeyPairsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyPairFingerPrint = javaType.keyPairFingerPrint().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pairs = javaType.pairs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecp.kotlin.outputs.GetKeyPairsPair.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
