@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Activation].
 */
@PulumiTagMarker
public class ActivationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActivationArgs = ActivationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActivationArgsBuilder.() -> Unit) {
        val builder = ActivationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Activation {
        val builtJavaResource = com.pulumi.alicloud.ecs.Activation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Activation(builtJavaResource)
    }
}

/**
 * Provides a ECS Activation resource.
 * For information about ECS Activation and how to use it, see [What is Activation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createactivation#doc-api-Ecs-CreateActivation).
 * > **NOTE:** Available in v1.177.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.Activation("example", {
 *     description: "terraform-example",
 *     instanceCount: 10,
 *     instanceName: "terraform-example",
 *     ipAddressRange: "0.0.0.0/0",
 *     timeToLiveInHours: 4,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.Activation("example",
 *     description="terraform-example",
 *     instance_count=10,
 *     instance_name="terraform-example",
 *     ip_address_range="0.0.0.0/0",
 *     time_to_live_in_hours=4)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.Activation("example", new()
 *     {
 *         Description = "terraform-example",
 *         InstanceCount = 10,
 *         InstanceName = "terraform-example",
 *         IpAddressRange = "0.0.0.0/0",
 *         TimeToLiveInHours = 4,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewActivation(ctx, "example", &ecs.ActivationArgs{
 * 			Description:       pulumi.String("terraform-example"),
 * 			InstanceCount:     pulumi.Int(10),
 * 			InstanceName:      pulumi.String("terraform-example"),
 * 			IpAddressRange:    pulumi.String("0.0.0.0/0"),
 * 			TimeToLiveInHours: pulumi.Int(4),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Activation;
 * import com.pulumi.alicloud.ecs.ActivationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Activation("example", ActivationArgs.builder()
 *             .description("terraform-example")
 *             .instanceCount(10)
 *             .instanceName("terraform-example")
 *             .ipAddressRange("0.0.0.0/0")
 *             .timeToLiveInHours(4)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:Activation
 *     properties:
 *       description: terraform-example
 *       instanceCount: 10
 *       instanceName: terraform-example
 *       ipAddressRange: 0.0.0.0/0
 *       timeToLiveInHours: 4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Activation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/activation:Activation example <id>
 * ```
 */
public class Activation internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.Activation,
) : KotlinCustomResource(javaResource, ActivationMapper) {
    /**
     * The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
     */
    public val instanceCount: Output<Int>
        get() = javaResource.instanceCount().applyValue({ args0 -> args0 })

    /**
     * The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
     * - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
     * - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
     */
    public val ipAddressRange: Output<String>
        get() = javaResource.ipAddressRange().applyValue({ args0 -> args0 })

    /**
     * The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
     */
    public val timeToLiveInHours: Output<Int>
        get() = javaResource.timeToLiveInHours().applyValue({ args0 -> args0 })
}

public object ActivationMapper : ResourceMapper<Activation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.Activation::class == javaResource::class

    override fun map(javaResource: Resource): Activation = Activation(
        javaResource as
            com.pulumi.alicloud.ecs.Activation,
    )
}

/**
 * @see [Activation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Activation].
 */
public suspend fun activation(name: String, block: suspend ActivationResourceBuilder.() -> Unit): Activation {
    val builder = ActivationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Activation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun activation(name: String): Activation {
    val builder = ActivationResourceBuilder()
    builder.name(name)
    return builder.build()
}
