@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.ActivationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECS Activation resource.
 * For information about ECS Activation and how to use it, see [What is Activation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createactivation#doc-api-Ecs-CreateActivation).
 * > **NOTE:** Available in v1.177.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.Activation("example", {
 *     description: "terraform-example",
 *     instanceCount: 10,
 *     instanceName: "terraform-example",
 *     ipAddressRange: "0.0.0.0/0",
 *     timeToLiveInHours: 4,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.Activation("example",
 *     description="terraform-example",
 *     instance_count=10,
 *     instance_name="terraform-example",
 *     ip_address_range="0.0.0.0/0",
 *     time_to_live_in_hours=4)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.Activation("example", new()
 *     {
 *         Description = "terraform-example",
 *         InstanceCount = 10,
 *         InstanceName = "terraform-example",
 *         IpAddressRange = "0.0.0.0/0",
 *         TimeToLiveInHours = 4,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewActivation(ctx, "example", &ecs.ActivationArgs{
 * 			Description:       pulumi.String("terraform-example"),
 * 			InstanceCount:     pulumi.Int(10),
 * 			InstanceName:      pulumi.String("terraform-example"),
 * 			IpAddressRange:    pulumi.String("0.0.0.0/0"),
 * 			TimeToLiveInHours: pulumi.Int(4),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Activation;
 * import com.pulumi.alicloud.ecs.ActivationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Activation("example", ActivationArgs.builder()
 *             .description("terraform-example")
 *             .instanceCount(10)
 *             .instanceName("terraform-example")
 *             .ipAddressRange("0.0.0.0/0")
 *             .timeToLiveInHours(4)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:Activation
 *     properties:
 *       description: terraform-example
 *       instanceCount: 10
 *       instanceName: terraform-example
 *       ipAddressRange: 0.0.0.0/0
 *       timeToLiveInHours: 4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Activation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/activation:Activation example <id>
 * ```
 * @property description The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
 * @property instanceCount The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
 * @property instanceName The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
 * - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
 * - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
 * @property ipAddressRange The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
 * @property timeToLiveInHours The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
 */
public data class ActivationArgs(
    public val description: Output<String>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceName: Output<String>? = null,
    public val ipAddressRange: Output<String>? = null,
    public val timeToLiveInHours: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.ActivationArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.ActivationArgs =
        com.pulumi.alicloud.ecs.ActivationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .ipAddressRange(ipAddressRange?.applyValue({ args0 -> args0 }))
            .timeToLiveInHours(timeToLiveInHours?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActivationArgs].
 */
@PulumiTagMarker
public class ActivationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceName: Output<String>? = null

    private var ipAddressRange: Output<String>? = null

    private var timeToLiveInHours: Output<Int>? = null

    /**
     * @param value The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("xoqeuvehsrxmyilm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
     */
    @JvmName("wsgdiafydbtepttv")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
     * - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
     * - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
     */
    @JvmName("vjmmwppcwgurnvan")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
     */
    @JvmName("roddtdcwyuegeons")
    public suspend fun ipAddressRange(`value`: Output<String>) {
        this.ipAddressRange = value
    }

    /**
     * @param value The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
     */
    @JvmName("lromfagqqihqboma")
    public suspend fun timeToLiveInHours(`value`: Output<Int>) {
        this.timeToLiveInHours = value
    }

    /**
     * @param value The description of the activation code. The description can be 1 to 100 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("gemhumbawjugbuic")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The maximum number of times that the activation code can be used to register managed instances. Valid values: `1` to `1000`. Default value: `10`.
     */
    @JvmName("nevdkcwkgtmyiper")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The default instance name prefix. The instance name prefix must be 1 to 50 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The instance name prefix can contain only letters, digits, periods (.), underscores (_), hyphens (-), and colons (:).
     * - If you use the activation code created by the CreateActivation operation to register managed instances, the instances are assigned sequential names that are prefixed by the value of this parameter. You can also specify a new instance name to override the assigned sequential name when you register a managed instance.
     * - If you specify InstanceName when you register a managed instance, an instance name in the format of `<InstanceName>-<Number>` is generated. The number of digits in the <Number> value is determined by that in the InstanceCount value. Example: 001. If you do not specify InstanceName, the hostname (Hostname) is used as the instance name.
     */
    @JvmName("obfekxafjdxqmwwh")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The IP addresses of hosts that are allowed to use the activation code. The value can be IPv4 addresses, IPv6 addresses, or CIDR blocks.
     */
    @JvmName("scsrclhxwokvgnxf")
    public suspend fun ipAddressRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressRange = mapped
    }

    /**
     * @param value The validity period of the activation code. The activation code cannot be used to register new instances after the validity period expires. Unit: hours. Valid values: `1` to `24`. Default value: `4`.
     */
    @JvmName("owtilaaqqjavmphr")
    public suspend fun timeToLiveInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToLiveInHours = mapped
    }

    internal fun build(): ActivationArgs = ActivationArgs(
        description = description,
        instanceCount = instanceCount,
        instanceName = instanceName,
        ipAddressRange = ipAddressRange,
        timeToLiveInHours = timeToLiveInHours,
    )
}
