@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.AutoProvisioningGroupLaunchTemplateConfig
import com.pulumi.alicloud.ecs.kotlin.outputs.AutoProvisioningGroupLaunchTemplateConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AutoProvisioningGroup].
 */
@PulumiTagMarker
public class AutoProvisioningGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoProvisioningGroupArgs = AutoProvisioningGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoProvisioningGroupArgsBuilder.() -> Unit) {
        val builder = AutoProvisioningGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutoProvisioningGroup {
        val builtJavaResource = com.pulumi.alicloud.ecs.AutoProvisioningGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AutoProvisioningGroup(builtJavaResource)
    }
}

/**
 * Provides a ECS auto provisioning group resource which is a solution that uses preemptive instances and pay_as_you_go instances to rapidly deploy clusters.
 * > **NOTE:** Available in 1.79.0+
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "auto_provisioning_group";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const template = new alicloud.ecs.EcsLaunchTemplate("template", {
 *     name: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: "ecs.n1.tiny",
 *     securityGroupId: defaultSecurityGroup.id,
 * });
 * const defaultAutoProvisioningGroup = new alicloud.ecs.AutoProvisioningGroup("default", {
 *     launchTemplateId: template.id,
 *     totalTargetCapacity: "4",
 *     payAsYouGoTargetCapacity: "1",
 *     spotTargetCapacity: "2",
 *     launchTemplateConfigs: [{
 *         instanceType: "ecs.n1.small",
 *         vswitchId: defaultSwitch.id,
 *         weightedCapacity: "2",
 *         maxPrice: "2",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "auto_provisioning_group"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * template = alicloud.ecs.EcsLaunchTemplate("template",
 *     name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type="ecs.n1.tiny",
 *     security_group_id=default_security_group.id)
 * default_auto_provisioning_group = alicloud.ecs.AutoProvisioningGroup("default",
 *     launch_template_id=template.id,
 *     total_target_capacity="4",
 *     pay_as_you_go_target_capacity="1",
 *     spot_target_capacity="2",
 *     launch_template_configs=[{
 *         "instance_type": "ecs.n1.small",
 *         "vswitch_id": default_switch.id,
 *         "weighted_capacity": "2",
 *         "max_price": "2",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "auto_provisioning_group";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var template = new AliCloud.Ecs.EcsLaunchTemplate("template", new()
 *     {
 *         Name = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = "ecs.n1.tiny",
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *     });
 *     var defaultAutoProvisioningGroup = new AliCloud.Ecs.AutoProvisioningGroup("default", new()
 *     {
 *         LaunchTemplateId = template.Id,
 *         TotalTargetCapacity = "4",
 *         PayAsYouGoTargetCapacity = "1",
 *         SpotTargetCapacity = "2",
 *         LaunchTemplateConfigs = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.AutoProvisioningGroupLaunchTemplateConfigArgs
 *             {
 *                 InstanceType = "ecs.n1.small",
 *                 VswitchId = defaultSwitch.Id,
 *                 WeightedCapacity = "2",
 *                 MaxPrice = "2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "auto_provisioning_group"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		template, err := ecs.NewEcsLaunchTemplate(ctx, "template", &ecs.EcsLaunchTemplateArgs{
 * 			Name:            pulumi.String(name),
 * 			ImageId:         pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:    pulumi.String("ecs.n1.tiny"),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewAutoProvisioningGroup(ctx, "default", &ecs.AutoProvisioningGroupArgs{
 * 			LaunchTemplateId:         template.ID(),
 * 			TotalTargetCapacity:      pulumi.String("4"),
 * 			PayAsYouGoTargetCapacity: pulumi.String("1"),
 * 			SpotTargetCapacity:       pulumi.String("2"),
 * 			LaunchTemplateConfigs: ecs.AutoProvisioningGroupLaunchTemplateConfigArray{
 * 				&ecs.AutoProvisioningGroupLaunchTemplateConfigArgs{
 * 					InstanceType:     pulumi.String("ecs.n1.small"),
 * 					VswitchId:        defaultSwitch.ID(),
 * 					WeightedCapacity: pulumi.String("2"),
 * 					MaxPrice:         pulumi.String("2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplate;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs;
 * import com.pulumi.alicloud.ecs.AutoProvisioningGroup;
 * import com.pulumi.alicloud.ecs.AutoProvisioningGroupArgs;
 * import com.pulumi.alicloud.ecs.inputs.AutoProvisioningGroupLaunchTemplateConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("auto_provisioning_group");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var template = new EcsLaunchTemplate("template", EcsLaunchTemplateArgs.builder()
 *             .name(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType("ecs.n1.tiny")
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .build());
 *         var defaultAutoProvisioningGroup = new AutoProvisioningGroup("defaultAutoProvisioningGroup", AutoProvisioningGroupArgs.builder()
 *             .launchTemplateId(template.id())
 *             .totalTargetCapacity("4")
 *             .payAsYouGoTargetCapacity("1")
 *             .spotTargetCapacity("2")
 *             .launchTemplateConfigs(AutoProvisioningGroupLaunchTemplateConfigArgs.builder()
 *                 .instanceType("ecs.n1.small")
 *                 .vswitchId(defaultSwitch.id())
 *                 .weightedCapacity("2")
 *                 .maxPrice("2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: auto_provisioning_group
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultAutoProvisioningGroup:
 *     type: alicloud:ecs:AutoProvisioningGroup
 *     name: default
 *     properties:
 *       launchTemplateId: ${template.id}
 *       totalTargetCapacity: '4'
 *       payAsYouGoTargetCapacity: '1'
 *       spotTargetCapacity: '2'
 *       launchTemplateConfigs:
 *         - instanceType: ecs.n1.small
 *           vswitchId: ${defaultSwitch.id}
 *           weightedCapacity: '2'
 *           maxPrice: '2'
 *   template:
 *     type: alicloud:ecs:EcsLaunchTemplate
 *     properties:
 *       name: ${name}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ecs.n1.tiny
 *       securityGroupId: ${defaultSecurityGroup.id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS auto provisioning group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/autoProvisioningGroup:AutoProvisioningGroup example asg-abc123456
 * ```
 */
public class AutoProvisioningGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.AutoProvisioningGroup,
) : KotlinCustomResource(javaResource, AutoProvisioningGroupMapper) {
    /**
     * The name of the auto provisioning group to be created. It must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-)
     */
    public val autoProvisioningGroupName: Output<String>
        get() = javaResource.autoProvisioningGroupName().applyValue({ args0 -> args0 })

    /**
     * The type of the auto provisioning group. Valid values:`request` and `maintain`,Default value: `maintain`.
     */
    public val autoProvisioningGroupType: Output<String>?
        get() = javaResource.autoProvisioningGroupType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of supplemental instances. When the total value of `PayAsYouGoTargetCapacity` and `SpotTargetCapacity` is smaller than the value of TotalTargetCapacity, the auto provisioning group will create instances of the specified type to meet the capacity requirements. Valid values:`PayAsYouGo`: Pay-as-you-go instances; `Spot`: Preemptible instances, Default value: `Spot`.
     */
    public val defaultTargetCapacityType: Output<String>?
        get() = javaResource.defaultTargetCapacityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the auto provisioning group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The shutdown policy for excess preemptible instances followed when the capacity of the auto provisioning group exceeds the target capacity. Valid values: `no-termination` and `termination`,Default value: `no-termination`.
     */
    public val excessCapacityTerminationPolicy: Output<String>?
        get() = javaResource.excessCapacityTerminationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    public val launchTemplateConfigs: Output<List<AutoProvisioningGroupLaunchTemplateConfig>>
        get() = javaResource.launchTemplateConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The ID of the instance launch template associated with the auto provisioning group.
     */
    public val launchTemplateId: Output<String>
        get() = javaResource.launchTemplateId().applyValue({ args0 -> args0 })

    /**
     * The version of the instance launch template associated with the auto provisioning group.
     */
    public val launchTemplateVersion: Output<String>
        get() = javaResource.launchTemplateVersion().applyValue({ args0 -> args0 })

    /**
     * The global maximum price for preemptible instances in the auto provisioning group. If both the `MaxSpotPrice` and `LaunchTemplateConfig.N.MaxPrice` parameters are specified, the maximum price is the lower value of the two.
     */
    public val maxSpotPrice: Output<Double>
        get() = javaResource.maxSpotPrice().applyValue({ args0 -> args0 })

    /**
     * The scale-out policy for pay-as-you-go instances. Valid values: `lowest-price` and `prioritized`,Default value: `lowest-price`.
     */
    public val payAsYouGoAllocationStrategy: Output<String>?
        get() = javaResource.payAsYouGoAllocationStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The target capacity of pay-as-you-go instances in the auto provisioning group.
     */
    public val payAsYouGoTargetCapacity: Output<String>?
        get() = javaResource.payAsYouGoTargetCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The scale-out policy for preemptible instances. Valid values:`lowest-price` and `diversified`,Default value: `lowest-price`.
     */
    public val spotAllocationStrategy: Output<String>?
        get() = javaResource.spotAllocationStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default behavior after preemptible instances are shut down. Valid values: `stop` and `terminate`,Default value: `stop`.
     */
    public val spotInstanceInterruptionBehavior: Output<String>?
        get() = javaResource.spotInstanceInterruptionBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This parameter takes effect when the `SpotAllocationStrategy` parameter is set to `lowest-price`. The auto provisioning group selects instance types of the lowest cost to create instances.
     */
    public val spotInstancePoolsToUseCount: Output<Int>
        get() = javaResource.spotInstancePoolsToUseCount().applyValue({ args0 -> args0 })

    /**
     * The target capacity of preemptible instances in the auto provisioning group.
     */
    public val spotTargetCapacity: Output<String>?
        get() = javaResource.spotTargetCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to release instances of the auto provisioning group. Valid values:`false` and `true`, default value: `false`.
     */
    public val terminateInstances: Output<Boolean>?
        get() = javaResource.terminateInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The shutdown policy for preemptible instances when the auto provisioning group expires. Valid values: `false` and `true`, default value: `false`.
     */
    public val terminateInstancesWithExpiration: Output<Boolean>?
        get() = javaResource.terminateInstancesWithExpiration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The total target capacity of the auto provisioning group. The target capacity consists of the following three parts:PayAsYouGoTargetCapacity,SpotTargetCapacity and the supplemental capacity besides PayAsYouGoTargetCapacity and SpotTargetCapacity.
     */
    public val totalTargetCapacity: Output<String>
        get() = javaResource.totalTargetCapacity().applyValue({ args0 -> args0 })

    /**
     * The time when the auto provisioning group is started. The period of time between this point in time and the point in time specified by the `valid_until` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group is immediately started after creation.
     */
    public val validFrom: Output<String>
        get() = javaResource.validFrom().applyValue({ args0 -> args0 })

    /**
     * The time when the auto provisioning group expires. The period of time between this point in time and the point in time specified by the `valid_from` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group never expires.
     */
    public val validUntil: Output<String>
        get() = javaResource.validUntil().applyValue({ args0 -> args0 })
}

public object AutoProvisioningGroupMapper : ResourceMapper<AutoProvisioningGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.AutoProvisioningGroup::class == javaResource::class

    override fun map(javaResource: Resource): AutoProvisioningGroup =
        AutoProvisioningGroup(javaResource as com.pulumi.alicloud.ecs.AutoProvisioningGroup)
}

/**
 * @see [AutoProvisioningGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoProvisioningGroup].
 */
public suspend fun autoProvisioningGroup(
    name: String,
    block: suspend AutoProvisioningGroupResourceBuilder.() -> Unit,
): AutoProvisioningGroup {
    val builder = AutoProvisioningGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoProvisioningGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoProvisioningGroup(name: String): AutoProvisioningGroup {
    val builder = AutoProvisioningGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
