@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.AutoProvisioningGroupArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.AutoProvisioningGroupLaunchTemplateConfigArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.AutoProvisioningGroupLaunchTemplateConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ECS auto provisioning group resource which is a solution that uses preemptive instances and pay_as_you_go instances to rapidly deploy clusters.
 * > **NOTE:** Available in 1.79.0+
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "auto_provisioning_group";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const template = new alicloud.ecs.EcsLaunchTemplate("template", {
 *     name: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: "ecs.n1.tiny",
 *     securityGroupId: defaultSecurityGroup.id,
 * });
 * const defaultAutoProvisioningGroup = new alicloud.ecs.AutoProvisioningGroup("default", {
 *     launchTemplateId: template.id,
 *     totalTargetCapacity: "4",
 *     payAsYouGoTargetCapacity: "1",
 *     spotTargetCapacity: "2",
 *     launchTemplateConfigs: [{
 *         instanceType: "ecs.n1.small",
 *         vswitchId: defaultSwitch.id,
 *         weightedCapacity: "2",
 *         maxPrice: "2",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "auto_provisioning_group"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * template = alicloud.ecs.EcsLaunchTemplate("template",
 *     name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type="ecs.n1.tiny",
 *     security_group_id=default_security_group.id)
 * default_auto_provisioning_group = alicloud.ecs.AutoProvisioningGroup("default",
 *     launch_template_id=template.id,
 *     total_target_capacity="4",
 *     pay_as_you_go_target_capacity="1",
 *     spot_target_capacity="2",
 *     launch_template_configs=[{
 *         "instance_type": "ecs.n1.small",
 *         "vswitch_id": default_switch.id,
 *         "weighted_capacity": "2",
 *         "max_price": "2",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "auto_provisioning_group";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var template = new AliCloud.Ecs.EcsLaunchTemplate("template", new()
 *     {
 *         Name = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = "ecs.n1.tiny",
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *     });
 *     var defaultAutoProvisioningGroup = new AliCloud.Ecs.AutoProvisioningGroup("default", new()
 *     {
 *         LaunchTemplateId = template.Id,
 *         TotalTargetCapacity = "4",
 *         PayAsYouGoTargetCapacity = "1",
 *         SpotTargetCapacity = "2",
 *         LaunchTemplateConfigs = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.AutoProvisioningGroupLaunchTemplateConfigArgs
 *             {
 *                 InstanceType = "ecs.n1.small",
 *                 VswitchId = defaultSwitch.Id,
 *                 WeightedCapacity = "2",
 *                 MaxPrice = "2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "auto_provisioning_group"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		template, err := ecs.NewEcsLaunchTemplate(ctx, "template", &ecs.EcsLaunchTemplateArgs{
 * 			Name:            pulumi.String(name),
 * 			ImageId:         pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:    pulumi.String("ecs.n1.tiny"),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewAutoProvisioningGroup(ctx, "default", &ecs.AutoProvisioningGroupArgs{
 * 			LaunchTemplateId:         template.ID(),
 * 			TotalTargetCapacity:      pulumi.String("4"),
 * 			PayAsYouGoTargetCapacity: pulumi.String("1"),
 * 			SpotTargetCapacity:       pulumi.String("2"),
 * 			LaunchTemplateConfigs: ecs.AutoProvisioningGroupLaunchTemplateConfigArray{
 * 				&ecs.AutoProvisioningGroupLaunchTemplateConfigArgs{
 * 					InstanceType:     pulumi.String("ecs.n1.small"),
 * 					VswitchId:        defaultSwitch.ID(),
 * 					WeightedCapacity: pulumi.String("2"),
 * 					MaxPrice:         pulumi.String("2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplate;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs;
 * import com.pulumi.alicloud.ecs.AutoProvisioningGroup;
 * import com.pulumi.alicloud.ecs.AutoProvisioningGroupArgs;
 * import com.pulumi.alicloud.ecs.inputs.AutoProvisioningGroupLaunchTemplateConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("auto_provisioning_group");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var template = new EcsLaunchTemplate("template", EcsLaunchTemplateArgs.builder()
 *             .name(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType("ecs.n1.tiny")
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .build());
 *         var defaultAutoProvisioningGroup = new AutoProvisioningGroup("defaultAutoProvisioningGroup", AutoProvisioningGroupArgs.builder()
 *             .launchTemplateId(template.id())
 *             .totalTargetCapacity("4")
 *             .payAsYouGoTargetCapacity("1")
 *             .spotTargetCapacity("2")
 *             .launchTemplateConfigs(AutoProvisioningGroupLaunchTemplateConfigArgs.builder()
 *                 .instanceType("ecs.n1.small")
 *                 .vswitchId(defaultSwitch.id())
 *                 .weightedCapacity("2")
 *                 .maxPrice("2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: auto_provisioning_group
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultAutoProvisioningGroup:
 *     type: alicloud:ecs:AutoProvisioningGroup
 *     name: default
 *     properties:
 *       launchTemplateId: ${template.id}
 *       totalTargetCapacity: '4'
 *       payAsYouGoTargetCapacity: '1'
 *       spotTargetCapacity: '2'
 *       launchTemplateConfigs:
 *         - instanceType: ecs.n1.small
 *           vswitchId: ${defaultSwitch.id}
 *           weightedCapacity: '2'
 *           maxPrice: '2'
 *   template:
 *     type: alicloud:ecs:EcsLaunchTemplate
 *     properties:
 *       name: ${name}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ecs.n1.tiny
 *       securityGroupId: ${defaultSecurityGroup.id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS auto provisioning group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/autoProvisioningGroup:AutoProvisioningGroup example asg-abc123456
 * ```
 * @property autoProvisioningGroupName The name of the auto provisioning group to be created. It must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-)
 * @property autoProvisioningGroupType The type of the auto provisioning group. Valid values:`request` and `maintain`,Default value: `maintain`.
 * @property defaultTargetCapacityType The type of supplemental instances. When the total value of `PayAsYouGoTargetCapacity` and `SpotTargetCapacity` is smaller than the value of TotalTargetCapacity, the auto provisioning group will create instances of the specified type to meet the capacity requirements. Valid values:`PayAsYouGo`: Pay-as-you-go instances; `Spot`: Preemptible instances, Default value: `Spot`.
 * @property description The description of the auto provisioning group.
 * @property excessCapacityTerminationPolicy The shutdown policy for excess preemptible instances followed when the capacity of the auto provisioning group exceeds the target capacity. Valid values: `no-termination` and `termination`,Default value: `no-termination`.
 * @property launchTemplateConfigs DataDisk mappings to attach to ecs instance. See `block-config` below for details.
 * @property launchTemplateId The ID of the instance launch template associated with the auto provisioning group.
 * @property launchTemplateVersion The version of the instance launch template associated with the auto provisioning group.
 * @property maxSpotPrice The global maximum price for preemptible instances in the auto provisioning group. If both the `MaxSpotPrice` and `LaunchTemplateConfig.N.MaxPrice` parameters are specified, the maximum price is the lower value of the two.
 * @property payAsYouGoAllocationStrategy The scale-out policy for pay-as-you-go instances. Valid values: `lowest-price` and `prioritized`,Default value: `lowest-price`.
 * @property payAsYouGoTargetCapacity The target capacity of pay-as-you-go instances in the auto provisioning group.
 * @property spotAllocationStrategy The scale-out policy for preemptible instances. Valid values:`lowest-price` and `diversified`,Default value: `lowest-price`.
 * @property spotInstanceInterruptionBehavior The default behavior after preemptible instances are shut down. Valid values: `stop` and `terminate`,Default value: `stop`.
 * @property spotInstancePoolsToUseCount This parameter takes effect when the `SpotAllocationStrategy` parameter is set to `lowest-price`. The auto provisioning group selects instance types of the lowest cost to create instances.
 * @property spotTargetCapacity The target capacity of preemptible instances in the auto provisioning group.
 * @property terminateInstances Specifies whether to release instances of the auto provisioning group. Valid values:`false` and `true`, default value: `false`.
 * @property terminateInstancesWithExpiration The shutdown policy for preemptible instances when the auto provisioning group expires. Valid values: `false` and `true`, default value: `false`.
 * @property totalTargetCapacity The total target capacity of the auto provisioning group. The target capacity consists of the following three parts:PayAsYouGoTargetCapacity,SpotTargetCapacity and the supplemental capacity besides PayAsYouGoTargetCapacity and SpotTargetCapacity.
 * @property validFrom The time when the auto provisioning group is started. The period of time between this point in time and the point in time specified by the `valid_until` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group is immediately started after creation.
 * @property validUntil The time when the auto provisioning group expires. The period of time between this point in time and the point in time specified by the `valid_from` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group never expires.
 */
public data class AutoProvisioningGroupArgs(
    public val autoProvisioningGroupName: Output<String>? = null,
    public val autoProvisioningGroupType: Output<String>? = null,
    public val defaultTargetCapacityType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val excessCapacityTerminationPolicy: Output<String>? = null,
    public val launchTemplateConfigs: Output<List<AutoProvisioningGroupLaunchTemplateConfigArgs>>? =
        null,
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateVersion: Output<String>? = null,
    public val maxSpotPrice: Output<Double>? = null,
    public val payAsYouGoAllocationStrategy: Output<String>? = null,
    public val payAsYouGoTargetCapacity: Output<String>? = null,
    public val spotAllocationStrategy: Output<String>? = null,
    public val spotInstanceInterruptionBehavior: Output<String>? = null,
    public val spotInstancePoolsToUseCount: Output<Int>? = null,
    public val spotTargetCapacity: Output<String>? = null,
    public val terminateInstances: Output<Boolean>? = null,
    public val terminateInstancesWithExpiration: Output<Boolean>? = null,
    public val totalTargetCapacity: Output<String>? = null,
    public val validFrom: Output<String>? = null,
    public val validUntil: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.AutoProvisioningGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.AutoProvisioningGroupArgs =
        com.pulumi.alicloud.ecs.AutoProvisioningGroupArgs.builder()
            .autoProvisioningGroupName(autoProvisioningGroupName?.applyValue({ args0 -> args0 }))
            .autoProvisioningGroupType(autoProvisioningGroupType?.applyValue({ args0 -> args0 }))
            .defaultTargetCapacityType(defaultTargetCapacityType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .excessCapacityTerminationPolicy(excessCapacityTerminationPolicy?.applyValue({ args0 -> args0 }))
            .launchTemplateConfigs(
                launchTemplateConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateVersion(launchTemplateVersion?.applyValue({ args0 -> args0 }))
            .maxSpotPrice(maxSpotPrice?.applyValue({ args0 -> args0 }))
            .payAsYouGoAllocationStrategy(payAsYouGoAllocationStrategy?.applyValue({ args0 -> args0 }))
            .payAsYouGoTargetCapacity(payAsYouGoTargetCapacity?.applyValue({ args0 -> args0 }))
            .spotAllocationStrategy(spotAllocationStrategy?.applyValue({ args0 -> args0 }))
            .spotInstanceInterruptionBehavior(spotInstanceInterruptionBehavior?.applyValue({ args0 -> args0 }))
            .spotInstancePoolsToUseCount(spotInstancePoolsToUseCount?.applyValue({ args0 -> args0 }))
            .spotTargetCapacity(spotTargetCapacity?.applyValue({ args0 -> args0 }))
            .terminateInstances(terminateInstances?.applyValue({ args0 -> args0 }))
            .terminateInstancesWithExpiration(terminateInstancesWithExpiration?.applyValue({ args0 -> args0 }))
            .totalTargetCapacity(totalTargetCapacity?.applyValue({ args0 -> args0 }))
            .validFrom(validFrom?.applyValue({ args0 -> args0 }))
            .validUntil(validUntil?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoProvisioningGroupArgs].
 */
@PulumiTagMarker
public class AutoProvisioningGroupArgsBuilder internal constructor() {
    private var autoProvisioningGroupName: Output<String>? = null

    private var autoProvisioningGroupType: Output<String>? = null

    private var defaultTargetCapacityType: Output<String>? = null

    private var description: Output<String>? = null

    private var excessCapacityTerminationPolicy: Output<String>? = null

    private var launchTemplateConfigs: Output<List<AutoProvisioningGroupLaunchTemplateConfigArgs>>? =
        null

    private var launchTemplateId: Output<String>? = null

    private var launchTemplateVersion: Output<String>? = null

    private var maxSpotPrice: Output<Double>? = null

    private var payAsYouGoAllocationStrategy: Output<String>? = null

    private var payAsYouGoTargetCapacity: Output<String>? = null

    private var spotAllocationStrategy: Output<String>? = null

    private var spotInstanceInterruptionBehavior: Output<String>? = null

    private var spotInstancePoolsToUseCount: Output<Int>? = null

    private var spotTargetCapacity: Output<String>? = null

    private var terminateInstances: Output<Boolean>? = null

    private var terminateInstancesWithExpiration: Output<Boolean>? = null

    private var totalTargetCapacity: Output<String>? = null

    private var validFrom: Output<String>? = null

    private var validUntil: Output<String>? = null

    /**
     * @param value The name of the auto provisioning group to be created. It must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-)
     */
    @JvmName("clfxmooqflogfsuc")
    public suspend fun autoProvisioningGroupName(`value`: Output<String>) {
        this.autoProvisioningGroupName = value
    }

    /**
     * @param value The type of the auto provisioning group. Valid values:`request` and `maintain`,Default value: `maintain`.
     */
    @JvmName("yoybatfidjwdhqmf")
    public suspend fun autoProvisioningGroupType(`value`: Output<String>) {
        this.autoProvisioningGroupType = value
    }

    /**
     * @param value The type of supplemental instances. When the total value of `PayAsYouGoTargetCapacity` and `SpotTargetCapacity` is smaller than the value of TotalTargetCapacity, the auto provisioning group will create instances of the specified type to meet the capacity requirements. Valid values:`PayAsYouGo`: Pay-as-you-go instances; `Spot`: Preemptible instances, Default value: `Spot`.
     */
    @JvmName("mcrydlpwdhlspvwm")
    public suspend fun defaultTargetCapacityType(`value`: Output<String>) {
        this.defaultTargetCapacityType = value
    }

    /**
     * @param value The description of the auto provisioning group.
     */
    @JvmName("skrgbnarosjkmgte")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The shutdown policy for excess preemptible instances followed when the capacity of the auto provisioning group exceeds the target capacity. Valid values: `no-termination` and `termination`,Default value: `no-termination`.
     */
    @JvmName("ayufmglymusejfll")
    public suspend fun excessCapacityTerminationPolicy(`value`: Output<String>) {
        this.excessCapacityTerminationPolicy = value
    }

    /**
     * @param value DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    @JvmName("vuyidajqiqbdbokd")
    public suspend fun launchTemplateConfigs(`value`: Output<List<AutoProvisioningGroupLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = value
    }

    @JvmName("ekfjlehkqvydfkfc")
    public suspend fun launchTemplateConfigs(vararg values: Output<AutoProvisioningGroupLaunchTemplateConfigArgs>) {
        this.launchTemplateConfigs = Output.all(values.asList())
    }

    /**
     * @param values DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    @JvmName("orvxywncbllkeman")
    public suspend fun launchTemplateConfigs(values: List<Output<AutoProvisioningGroupLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = Output.all(values)
    }

    /**
     * @param value The ID of the instance launch template associated with the auto provisioning group.
     */
    @JvmName("bgdqabxjhbkvhljv")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value The version of the instance launch template associated with the auto provisioning group.
     */
    @JvmName("lvwiixwsvtihqdkg")
    public suspend fun launchTemplateVersion(`value`: Output<String>) {
        this.launchTemplateVersion = value
    }

    /**
     * @param value The global maximum price for preemptible instances in the auto provisioning group. If both the `MaxSpotPrice` and `LaunchTemplateConfig.N.MaxPrice` parameters are specified, the maximum price is the lower value of the two.
     */
    @JvmName("xdbiptiaxwrkhrxd")
    public suspend fun maxSpotPrice(`value`: Output<Double>) {
        this.maxSpotPrice = value
    }

    /**
     * @param value The scale-out policy for pay-as-you-go instances. Valid values: `lowest-price` and `prioritized`,Default value: `lowest-price`.
     */
    @JvmName("cqobopivohxvsunq")
    public suspend fun payAsYouGoAllocationStrategy(`value`: Output<String>) {
        this.payAsYouGoAllocationStrategy = value
    }

    /**
     * @param value The target capacity of pay-as-you-go instances in the auto provisioning group.
     */
    @JvmName("tpgvcfotxmupvbxs")
    public suspend fun payAsYouGoTargetCapacity(`value`: Output<String>) {
        this.payAsYouGoTargetCapacity = value
    }

    /**
     * @param value The scale-out policy for preemptible instances. Valid values:`lowest-price` and `diversified`,Default value: `lowest-price`.
     */
    @JvmName("llkkuwvfoudsvdck")
    public suspend fun spotAllocationStrategy(`value`: Output<String>) {
        this.spotAllocationStrategy = value
    }

    /**
     * @param value The default behavior after preemptible instances are shut down. Valid values: `stop` and `terminate`,Default value: `stop`.
     */
    @JvmName("uqcfsetwnlijsbwk")
    public suspend fun spotInstanceInterruptionBehavior(`value`: Output<String>) {
        this.spotInstanceInterruptionBehavior = value
    }

    /**
     * @param value This parameter takes effect when the `SpotAllocationStrategy` parameter is set to `lowest-price`. The auto provisioning group selects instance types of the lowest cost to create instances.
     */
    @JvmName("iywmeupktwlvseam")
    public suspend fun spotInstancePoolsToUseCount(`value`: Output<Int>) {
        this.spotInstancePoolsToUseCount = value
    }

    /**
     * @param value The target capacity of preemptible instances in the auto provisioning group.
     */
    @JvmName("oswupjmuwvpxwgxt")
    public suspend fun spotTargetCapacity(`value`: Output<String>) {
        this.spotTargetCapacity = value
    }

    /**
     * @param value Specifies whether to release instances of the auto provisioning group. Valid values:`false` and `true`, default value: `false`.
     */
    @JvmName("xgxsoatumafmuicn")
    public suspend fun terminateInstances(`value`: Output<Boolean>) {
        this.terminateInstances = value
    }

    /**
     * @param value The shutdown policy for preemptible instances when the auto provisioning group expires. Valid values: `false` and `true`, default value: `false`.
     */
    @JvmName("umhuhtxhomgmtqwe")
    public suspend fun terminateInstancesWithExpiration(`value`: Output<Boolean>) {
        this.terminateInstancesWithExpiration = value
    }

    /**
     * @param value The total target capacity of the auto provisioning group. The target capacity consists of the following three parts:PayAsYouGoTargetCapacity,SpotTargetCapacity and the supplemental capacity besides PayAsYouGoTargetCapacity and SpotTargetCapacity.
     */
    @JvmName("naeqdklwglqyxjmg")
    public suspend fun totalTargetCapacity(`value`: Output<String>) {
        this.totalTargetCapacity = value
    }

    /**
     * @param value The time when the auto provisioning group is started. The period of time between this point in time and the point in time specified by the `valid_until` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group is immediately started after creation.
     */
    @JvmName("ptegouukimovaydq")
    public suspend fun validFrom(`value`: Output<String>) {
        this.validFrom = value
    }

    /**
     * @param value The time when the auto provisioning group expires. The period of time between this point in time and the point in time specified by the `valid_from` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group never expires.
     */
    @JvmName("mijrepynvkjdscty")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value The name of the auto provisioning group to be created. It must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-)
     */
    @JvmName("wfcijbrvnnxscarm")
    public suspend fun autoProvisioningGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoProvisioningGroupName = mapped
    }

    /**
     * @param value The type of the auto provisioning group. Valid values:`request` and `maintain`,Default value: `maintain`.
     */
    @JvmName("mrqdecxeqpqrrxsu")
    public suspend fun autoProvisioningGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoProvisioningGroupType = mapped
    }

    /**
     * @param value The type of supplemental instances. When the total value of `PayAsYouGoTargetCapacity` and `SpotTargetCapacity` is smaller than the value of TotalTargetCapacity, the auto provisioning group will create instances of the specified type to meet the capacity requirements. Valid values:`PayAsYouGo`: Pay-as-you-go instances; `Spot`: Preemptible instances, Default value: `Spot`.
     */
    @JvmName("cjelfcibdtjmynku")
    public suspend fun defaultTargetCapacityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTargetCapacityType = mapped
    }

    /**
     * @param value The description of the auto provisioning group.
     */
    @JvmName("iovjcdmektogaidm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The shutdown policy for excess preemptible instances followed when the capacity of the auto provisioning group exceeds the target capacity. Valid values: `no-termination` and `termination`,Default value: `no-termination`.
     */
    @JvmName("enmdchwdgnwyjubo")
    public suspend fun excessCapacityTerminationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excessCapacityTerminationPolicy = mapped
    }

    /**
     * @param value DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    @JvmName("lrtbvsyotqlaaelg")
    public suspend fun launchTemplateConfigs(`value`: List<AutoProvisioningGroupLaunchTemplateConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    @JvmName("uupetisoflncyqpp")
    public suspend fun launchTemplateConfigs(argument: List<suspend AutoProvisioningGroupLaunchTemplateConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutoProvisioningGroupLaunchTemplateConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    @JvmName("owesrjqrfelbflst")
    public suspend fun launchTemplateConfigs(vararg argument: suspend AutoProvisioningGroupLaunchTemplateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutoProvisioningGroupLaunchTemplateConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    @JvmName("wapfxaponwaprtjl")
    public suspend fun launchTemplateConfigs(argument: suspend AutoProvisioningGroupLaunchTemplateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutoProvisioningGroupLaunchTemplateConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param values DataDisk mappings to attach to ecs instance. See `block-config` below for details.
     */
    @JvmName("hldglhhruwyueuqs")
    public suspend fun launchTemplateConfigs(vararg values: AutoProvisioningGroupLaunchTemplateConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param value The ID of the instance launch template associated with the auto provisioning group.
     */
    @JvmName("lwqofixawcofcjos")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value The version of the instance launch template associated with the auto provisioning group.
     */
    @JvmName("flsnxpjsnommsaqr")
    public suspend fun launchTemplateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateVersion = mapped
    }

    /**
     * @param value The global maximum price for preemptible instances in the auto provisioning group. If both the `MaxSpotPrice` and `LaunchTemplateConfig.N.MaxPrice` parameters are specified, the maximum price is the lower value of the two.
     */
    @JvmName("bdqsjgqtiyxtojfp")
    public suspend fun maxSpotPrice(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSpotPrice = mapped
    }

    /**
     * @param value The scale-out policy for pay-as-you-go instances. Valid values: `lowest-price` and `prioritized`,Default value: `lowest-price`.
     */
    @JvmName("qeogidydijkmutur")
    public suspend fun payAsYouGoAllocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payAsYouGoAllocationStrategy = mapped
    }

    /**
     * @param value The target capacity of pay-as-you-go instances in the auto provisioning group.
     */
    @JvmName("xkiyscpbwlpyvypj")
    public suspend fun payAsYouGoTargetCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payAsYouGoTargetCapacity = mapped
    }

    /**
     * @param value The scale-out policy for preemptible instances. Valid values:`lowest-price` and `diversified`,Default value: `lowest-price`.
     */
    @JvmName("dhcbpfiimwugvoqc")
    public suspend fun spotAllocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotAllocationStrategy = mapped
    }

    /**
     * @param value The default behavior after preemptible instances are shut down. Valid values: `stop` and `terminate`,Default value: `stop`.
     */
    @JvmName("bvqxcnhmkqtomhle")
    public suspend fun spotInstanceInterruptionBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstanceInterruptionBehavior = mapped
    }

    /**
     * @param value This parameter takes effect when the `SpotAllocationStrategy` parameter is set to `lowest-price`. The auto provisioning group selects instance types of the lowest cost to create instances.
     */
    @JvmName("qnybsaxjuegdhumw")
    public suspend fun spotInstancePoolsToUseCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstancePoolsToUseCount = mapped
    }

    /**
     * @param value The target capacity of preemptible instances in the auto provisioning group.
     */
    @JvmName("yefgqjimnsosaxnx")
    public suspend fun spotTargetCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotTargetCapacity = mapped
    }

    /**
     * @param value Specifies whether to release instances of the auto provisioning group. Valid values:`false` and `true`, default value: `false`.
     */
    @JvmName("gvskegnlpurbjenv")
    public suspend fun terminateInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstances = mapped
    }

    /**
     * @param value The shutdown policy for preemptible instances when the auto provisioning group expires. Valid values: `false` and `true`, default value: `false`.
     */
    @JvmName("maoonjmrihkwqwvo")
    public suspend fun terminateInstancesWithExpiration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstancesWithExpiration = mapped
    }

    /**
     * @param value The total target capacity of the auto provisioning group. The target capacity consists of the following three parts:PayAsYouGoTargetCapacity,SpotTargetCapacity and the supplemental capacity besides PayAsYouGoTargetCapacity and SpotTargetCapacity.
     */
    @JvmName("vdgjjvklgupdcolk")
    public suspend fun totalTargetCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalTargetCapacity = mapped
    }

    /**
     * @param value The time when the auto provisioning group is started. The period of time between this point in time and the point in time specified by the `valid_until` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group is immediately started after creation.
     */
    @JvmName("qbbkbuudhceekiud")
    public suspend fun validFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validFrom = mapped
    }

    /**
     * @param value The time when the auto provisioning group expires. The period of time between this point in time and the point in time specified by the `valid_from` parameter is the effective time period of the auto provisioning group.By default, an auto provisioning group never expires.
     */
    @JvmName("qhaaauitlxseusbm")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    internal fun build(): AutoProvisioningGroupArgs = AutoProvisioningGroupArgs(
        autoProvisioningGroupName = autoProvisioningGroupName,
        autoProvisioningGroupType = autoProvisioningGroupType,
        defaultTargetCapacityType = defaultTargetCapacityType,
        description = description,
        excessCapacityTerminationPolicy = excessCapacityTerminationPolicy,
        launchTemplateConfigs = launchTemplateConfigs,
        launchTemplateId = launchTemplateId,
        launchTemplateVersion = launchTemplateVersion,
        maxSpotPrice = maxSpotPrice,
        payAsYouGoAllocationStrategy = payAsYouGoAllocationStrategy,
        payAsYouGoTargetCapacity = payAsYouGoTargetCapacity,
        spotAllocationStrategy = spotAllocationStrategy,
        spotInstanceInterruptionBehavior = spotInstanceInterruptionBehavior,
        spotInstancePoolsToUseCount = spotInstancePoolsToUseCount,
        spotTargetCapacity = spotTargetCapacity,
        terminateInstances = terminateInstances,
        terminateInstancesWithExpiration = terminateInstancesWithExpiration,
        totalTargetCapacity = totalTargetCapacity,
        validFrom = validFrom,
        validUntil = validUntil,
    )
}
