@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [AutoSnapshotPolicy].
 */
@PulumiTagMarker
public class AutoSnapshotPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoSnapshotPolicyArgs = AutoSnapshotPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoSnapshotPolicyArgsBuilder.() -> Unit) {
        val builder = AutoSnapshotPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutoSnapshotPolicy {
        val builtJavaResource = com.pulumi.alicloud.ecs.AutoSnapshotPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AutoSnapshotPolicy(builtJavaResource)
    }
}

/**
 * Provides a ECS Auto Snapshot Policy resource.
 * For information about ECS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/25527.htm).
 * > **NOTE:** Available in v1.117.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.AutoSnapshotPolicy("example", {
 *     name: "tf-testAcc",
 *     repeatWeekdays: [
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retentionDays: -1,
 *     timePoints: [
 *         "1",
 *         "22",
 *         "23",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.AutoSnapshotPolicy("example",
 *     name="tf-testAcc",
 *     repeat_weekdays=[
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retention_days=-1,
 *     time_points=[
 *         "1",
 *         "22",
 *         "23",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.AutoSnapshotPolicy("example", new()
 *     {
 *         Name = "tf-testAcc",
 *         RepeatWeekdays = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *         RetentionDays = -1,
 *         TimePoints = new[]
 *         {
 *             "1",
 *             "22",
 *             "23",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewAutoSnapshotPolicy(ctx, "example", &ecs.AutoSnapshotPolicyArgs{
 * 			Name: pulumi.String("tf-testAcc"),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 			RetentionDays: int(-1),
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("22"),
 * 				pulumi.String("23"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:AutoSnapshotPolicy
 *     properties:
 *       name: tf-testAcc
 *       repeatWeekdays:
 *         - '1'
 *         - '2'
 *         - '3'
 *       retentionDays: -1
 *       timePoints:
 *         - '1'
 *         - '22'
 *         - '23'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Auto Snapshot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
 * ```
 */
public class AutoSnapshotPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.AutoSnapshotPolicy,
) : KotlinCustomResource(javaResource, AutoSnapshotPolicyMapper) {
    /**
     * The retention period of the snapshot copied across regions.
     * - -1: The snapshot is permanently retained.
     * - [1, 65535]: The automatic snapshot is retained for the specified number of days.
     * Default value: -1.
     */
    public val copiedSnapshotsRetentionDays: Output<Int>?
        get() = javaResource.copiedSnapshotsRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable the system to automatically copy snapshots across regions.
     */
    public val enableCrossRegionCopy: Output<Boolean>?
        get() = javaResource.enableCrossRegionCopy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The snapshot policy name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    public val repeatWeekdays: Output<List<String>>
        get() = javaResource.repeatWeekdays().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The snapshot retention time, and the unit of measurement is day. Optional values:
     * - -1: The automatic snapshots are retained permanently.
     * - [1, 65536]: The number of days retained.
     * Default value: -1.
     */
    public val retentionDays: Output<Int>
        get() = javaResource.retentionDays().applyValue({ args0 -> args0 })

    /**
     * The status of Auto Snapshot Policy.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The destination region to which the snapshot is copied. You can set a destination region.
     */
    public val targetCopyRegions: Output<List<String>>?
        get() = javaResource.targetCopyRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    public val timePoints: Output<List<String>>
        get() = javaResource.timePoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object AutoSnapshotPolicyMapper : ResourceMapper<AutoSnapshotPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.AutoSnapshotPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AutoSnapshotPolicy = AutoSnapshotPolicy(
        javaResource as
            com.pulumi.alicloud.ecs.AutoSnapshotPolicy,
    )
}

/**
 * @see [AutoSnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoSnapshotPolicy].
 */
public suspend fun autoSnapshotPolicy(
    name: String,
    block: suspend AutoSnapshotPolicyResourceBuilder.() -> Unit,
): AutoSnapshotPolicy {
    val builder = AutoSnapshotPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoSnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoSnapshotPolicy(name: String): AutoSnapshotPolicy {
    val builder = AutoSnapshotPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
