@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.AutoSnapshotPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Auto Snapshot Policy resource.
 * For information about ECS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/25527.htm).
 * > **NOTE:** Available in v1.117.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.AutoSnapshotPolicy("example", {
 *     name: "tf-testAcc",
 *     repeatWeekdays: [
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retentionDays: -1,
 *     timePoints: [
 *         "1",
 *         "22",
 *         "23",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.AutoSnapshotPolicy("example",
 *     name="tf-testAcc",
 *     repeat_weekdays=[
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retention_days=-1,
 *     time_points=[
 *         "1",
 *         "22",
 *         "23",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.AutoSnapshotPolicy("example", new()
 *     {
 *         Name = "tf-testAcc",
 *         RepeatWeekdays = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *         RetentionDays = -1,
 *         TimePoints = new[]
 *         {
 *             "1",
 *             "22",
 *             "23",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewAutoSnapshotPolicy(ctx, "example", &ecs.AutoSnapshotPolicyArgs{
 * 			Name: pulumi.String("tf-testAcc"),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 			RetentionDays: int(-1),
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("22"),
 * 				pulumi.String("23"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:AutoSnapshotPolicy
 *     properties:
 *       name: tf-testAcc
 *       repeatWeekdays:
 *         - '1'
 *         - '2'
 *         - '3'
 *       retentionDays: -1
 *       timePoints:
 *         - '1'
 *         - '22'
 *         - '23'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Auto Snapshot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
 * ```
 * @property copiedSnapshotsRetentionDays The retention period of the snapshot copied across regions.
 * - -1: The snapshot is permanently retained.
 * - [1, 65535]: The automatic snapshot is retained for the specified number of days.
 * Default value: -1.
 * @property enableCrossRegionCopy Specifies whether to enable the system to automatically copy snapshots across regions.
 * @property name The snapshot policy name.
 * @property repeatWeekdays The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
 * - A maximum of seven time points can be selected.
 * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
 * @property retentionDays The snapshot retention time, and the unit of measurement is day. Optional values:
 * - -1: The automatic snapshots are retained permanently.
 * - [1, 65536]: The number of days retained.
 * Default value: -1.
 * @property tags A mapping of tags to assign to the resource.
 * @property targetCopyRegions The destination region to which the snapshot is copied. You can set a destination region.
 * @property timePoints The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
 * - A maximum of 24 time points can be selected.
 * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
 */
public data class AutoSnapshotPolicyArgs(
    public val copiedSnapshotsRetentionDays: Output<Int>? = null,
    public val enableCrossRegionCopy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val repeatWeekdays: Output<List<String>>? = null,
    public val retentionDays: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetCopyRegions: Output<List<String>>? = null,
    public val timePoints: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.AutoSnapshotPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.AutoSnapshotPolicyArgs =
        com.pulumi.alicloud.ecs.AutoSnapshotPolicyArgs.builder()
            .copiedSnapshotsRetentionDays(copiedSnapshotsRetentionDays?.applyValue({ args0 -> args0 }))
            .enableCrossRegionCopy(enableCrossRegionCopy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .repeatWeekdays(repeatWeekdays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetCopyRegions(targetCopyRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timePoints(timePoints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AutoSnapshotPolicyArgs].
 */
@PulumiTagMarker
public class AutoSnapshotPolicyArgsBuilder internal constructor() {
    private var copiedSnapshotsRetentionDays: Output<Int>? = null

    private var enableCrossRegionCopy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var repeatWeekdays: Output<List<String>>? = null

    private var retentionDays: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetCopyRegions: Output<List<String>>? = null

    private var timePoints: Output<List<String>>? = null

    /**
     * @param value The retention period of the snapshot copied across regions.
     * - -1: The snapshot is permanently retained.
     * - [1, 65535]: The automatic snapshot is retained for the specified number of days.
     * Default value: -1.
     */
    @JvmName("tmuilsqldprpotyx")
    public suspend fun copiedSnapshotsRetentionDays(`value`: Output<Int>) {
        this.copiedSnapshotsRetentionDays = value
    }

    /**
     * @param value Specifies whether to enable the system to automatically copy snapshots across regions.
     */
    @JvmName("vembxxstmgiedhfx")
    public suspend fun enableCrossRegionCopy(`value`: Output<Boolean>) {
        this.enableCrossRegionCopy = value
    }

    /**
     * @param value The snapshot policy name.
     */
    @JvmName("eudqybmskmvkbwig")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("uvffblewcodighyu")
    public suspend fun repeatWeekdays(`value`: Output<List<String>>) {
        this.repeatWeekdays = value
    }

    @JvmName("qpwaduenbjwklqef")
    public suspend fun repeatWeekdays(vararg values: Output<String>) {
        this.repeatWeekdays = Output.all(values.asList())
    }

    /**
     * @param values The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("dcoquxuvsmphqxbc")
    public suspend fun repeatWeekdays(values: List<Output<String>>) {
        this.repeatWeekdays = Output.all(values)
    }

    /**
     * @param value The snapshot retention time, and the unit of measurement is day. Optional values:
     * - -1: The automatic snapshots are retained permanently.
     * - [1, 65536]: The number of days retained.
     * Default value: -1.
     */
    @JvmName("nuxgsxnpoekocrvs")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("wlbbyvvdwexjxpjg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The destination region to which the snapshot is copied. You can set a destination region.
     */
    @JvmName("vupkyyxaijdoyovq")
    public suspend fun targetCopyRegions(`value`: Output<List<String>>) {
        this.targetCopyRegions = value
    }

    @JvmName("syyrnnlcsjyunbmo")
    public suspend fun targetCopyRegions(vararg values: Output<String>) {
        this.targetCopyRegions = Output.all(values.asList())
    }

    /**
     * @param values The destination region to which the snapshot is copied. You can set a destination region.
     */
    @JvmName("tstihabahnminbnu")
    public suspend fun targetCopyRegions(values: List<Output<String>>) {
        this.targetCopyRegions = Output.all(values)
    }

    /**
     * @param value The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("baoxoqhmrvxhnipg")
    public suspend fun timePoints(`value`: Output<List<String>>) {
        this.timePoints = value
    }

    @JvmName("hdgrkomjmbrtcatv")
    public suspend fun timePoints(vararg values: Output<String>) {
        this.timePoints = Output.all(values.asList())
    }

    /**
     * @param values The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("dgnfeqontkqkdkqt")
    public suspend fun timePoints(values: List<Output<String>>) {
        this.timePoints = Output.all(values)
    }

    /**
     * @param value The retention period of the snapshot copied across regions.
     * - -1: The snapshot is permanently retained.
     * - [1, 65535]: The automatic snapshot is retained for the specified number of days.
     * Default value: -1.
     */
    @JvmName("rqayhmfadftibumd")
    public suspend fun copiedSnapshotsRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copiedSnapshotsRetentionDays = mapped
    }

    /**
     * @param value Specifies whether to enable the system to automatically copy snapshots across regions.
     */
    @JvmName("hukqwecrfrvlbkgx")
    public suspend fun enableCrossRegionCopy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCrossRegionCopy = mapped
    }

    /**
     * @param value The snapshot policy name.
     */
    @JvmName("biyxhhiwuaejbhvu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("bwtoyrwphnvgpxba")
    public suspend fun repeatWeekdays(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param values The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("amdtybytmvvpxwmc")
    public suspend fun repeatWeekdays(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param value The snapshot retention time, and the unit of measurement is day. Optional values:
     * - -1: The automatic snapshots are retained permanently.
     * - [1, 65536]: The number of days retained.
     * Default value: -1.
     */
    @JvmName("qxfoceymleuejrdc")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("cxiollkdkhkyhtij")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("mxvjxcklpemvyocs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The destination region to which the snapshot is copied. You can set a destination region.
     */
    @JvmName("ovtiqlqtrlioioep")
    public suspend fun targetCopyRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCopyRegions = mapped
    }

    /**
     * @param values The destination region to which the snapshot is copied. You can set a destination region.
     */
    @JvmName("topoyhuwbvjltdoe")
    public suspend fun targetCopyRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetCopyRegions = mapped
    }

    /**
     * @param value The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("tlyxkqxeidhtlpbi")
    public suspend fun timePoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    /**
     * @param values The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("mngidftywlgulopl")
    public suspend fun timePoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    internal fun build(): AutoSnapshotPolicyArgs = AutoSnapshotPolicyArgs(
        copiedSnapshotsRetentionDays = copiedSnapshotsRetentionDays,
        enableCrossRegionCopy = enableCrossRegionCopy,
        name = name,
        repeatWeekdays = repeatWeekdays,
        retentionDays = retentionDays,
        tags = tags,
        targetCopyRegions = targetCopyRegions,
        timePoints = timePoints,
    )
}
