@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [CapacityReservation].
 */
@PulumiTagMarker
public class CapacityReservationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapacityReservationArgs = CapacityReservationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapacityReservationArgsBuilder.() -> Unit) {
        val builder = CapacityReservationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CapacityReservation {
        val builtJavaResource = com.pulumi.alicloud.ecs.CapacityReservation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CapacityReservation(builtJavaResource)
    }
}

/**
 * Provides a Ecs Capacity Reservation resource.
 * For information about Ecs Capacity Reservation and how to use it, see [What is Capacity Reservation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createcapacityreservation).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.ecs.getInstanceTypes({
 *     instanceTypeFamily: "ecs.g5",
 * });
 * const defaultGetZones = _default.then(_default => alicloud.getZones({
 *     availableResourceCreation: "Instance",
 *     availableInstanceType: _default.ids?.[0],
 * }));
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultCapacityReservation = new alicloud.ecs.CapacityReservation("default", {
 *     description: "terraform-example",
 *     platform: "linux",
 *     capacityReservationName: "terraform-example",
 *     endTimeType: "Unlimited",
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 *     instanceAmount: 1,
 *     instanceType: _default.then(_default => _default.ids?.[0]),
 *     matchCriteria: "Open",
 *     tags: {
 *         Created: "terraform-example",
 *     },
 *     zoneIds: [defaultGetZones&#46;then(defaultGetZones => defaultGetZones&#46;zones?&#46;[0]?&#46;id)],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.get_instance_types(instance_type_family="ecs.g5")
 * default_get_zones = alicloud.get_zones(available_resource_creation="Instance",
 *     available_instance_type=default.ids[0])
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_capacity_reservation = alicloud.ecs.CapacityReservation("default",
 *     description="terraform-example",
 *     platform="linux",
 *     capacity_reservation_name="terraform-example",
 *     end_time_type="Unlimited",
 *     resource_group_id=default_get_resource_groups.ids[0],
 *     instance_amount=1,
 *     instance_type=default.ids[0],
 *     match_criteria="Open",
 *     tags={
 *         "Created": "terraform-example",
 *     },
 *     zone_ids=[default_get_zones&#46;zones[0]&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "ecs.g5",
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *         AvailableInstanceType = @default.Apply(getInstanceTypesResult => getInstanceTypesResult.Ids[0]),
 *     });
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultCapacityReservation = new AliCloud.Ecs.CapacityReservation("default", new()
 *     {
 *         Description = "terraform-example",
 *         Platform = "linux",
 *         CapacityReservationName = "terraform-example",
 *         EndTimeType = "Unlimited",
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *         InstanceAmount = 1,
 *         InstanceType = @default.Apply(@default => @default.Apply(getInstanceTypesResult => getInstanceTypesResult.Ids[0])),
 *         MatchCriteria = "Open",
 *         Tags =
 *         {
 *             { "Created", "terraform-example" },
 *         },
 *         ZoneIds = new[]
 *         {
 *             defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.g5"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 			AvailableInstanceType:     pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewCapacityReservation(ctx, "default", &ecs.CapacityReservationArgs{
 * 			Description:             pulumi.String("terraform-example"),
 * 			Platform:                pulumi.String("linux"),
 * 			CapacityReservationName: pulumi.String("terraform-example"),
 * 			EndTimeType:             pulumi.String("Unlimited"),
 * 			ResourceGroupId:         pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 			InstanceAmount:          pulumi.Int(1),
 * 			InstanceType:            pulumi.String(_default.Ids[0]),
 * 			MatchCriteria:           pulumi.String("Open"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("terraform-example"),
 * 			},
 * 			ZoneIds: pulumi.StringArray{
 * 				pulumi.String(defaultGetZones.Zones[0].Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ecs.CapacityReservation;
 * import com.pulumi.alicloud.ecs.CapacityReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .instanceTypeFamily("ecs.g5")
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .availableInstanceType(default_.ids()[0])
 *             .build());
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultCapacityReservation = new CapacityReservation("defaultCapacityReservation", CapacityReservationArgs.builder()
 *             .description("terraform-example")
 *             .platform("linux")
 *             .capacityReservationName("terraform-example")
 *             .endTimeType("Unlimited")
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .instanceAmount(1)
 *             .instanceType(default_.ids()[0])
 *             .matchCriteria("Open")
 *             .tags(Map.of("Created", "terraform-example"))
 *             .zoneIds(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultCapacityReservation:
 *     type: alicloud:ecs:CapacityReservation
 *     name: default
 *     properties:
 *       description: terraform-example
 *       platform: linux
 *       capacityReservationName: terraform-example
 *       endTimeType: Unlimited
 *       resourceGroupId: ${defaultGetResourceGroups.ids[0]}
 *       instanceAmount: 1
 *       instanceType: ${default.ids[0]}
 *       matchCriteria: Open
 *       tags:
 *         Created: terraform-example
 *       zoneIds:
 *         - ${defaultGetZones.zones[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         instanceTypeFamily: ecs.g5
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *         availableInstanceType: ${default.ids[0]}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ecs Capacity Reservation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/capacityReservation:CapacityReservation example <id>
 * ```
 */
public class CapacityReservation internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.CapacityReservation,
) : KotlinCustomResource(javaResource, CapacityReservationMapper) {
    /**
     * Capacity reservation service name.
     */
    public val capacityReservationName: Output<String>
        get() = javaResource.capacityReservationName().applyValue({ args0 -> args0 })

    /**
     * description of the capacity reservation instance.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to pre-check the API request. Valid values: `true` and `false`.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
     */
    public val endTimeType: Output<String>
        get() = javaResource.endTimeType().applyValue({ args0 -> args0 })

    /**
     * The total number of instances that need to be reserved within the capacity reservation.
     */
    public val instanceAmount: Output<Int>
        get() = javaResource.instanceAmount().applyValue({ args0 -> args0 })

    /**
     * Instance type. Currently, you can only set the capacity reservation service for one instance type.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
     */
    public val matchCriteria: Output<String>
        get() = javaResource.matchCriteria().applyValue({ args0 -> args0 })

    /**
     * The payment type of the resource
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * platform of the capacity reservation, value range `windows`, `linux`.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * The resource group id.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * time of the capacity reservation which become active.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
     */
    public val startTimeType: Output<String>
        get() = javaResource.startTimeType().applyValue({ args0 -> args0 })

    /**
     * The status of the capacity reservation.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * This parameter is under test and is not yet open for use.
     */
    public val timeSlot: Output<String>
        get() = javaResource.timeSlot().applyValue({ args0 -> args0 })

    /**
     * The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
     */
    public val zoneIds: Output<List<String>>
        get() = javaResource.zoneIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object CapacityReservationMapper : ResourceMapper<CapacityReservation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.CapacityReservation::class == javaResource::class

    override fun map(javaResource: Resource): CapacityReservation = CapacityReservation(
        javaResource
            as com.pulumi.alicloud.ecs.CapacityReservation,
    )
}

/**
 * @see [CapacityReservation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CapacityReservation].
 */
public suspend fun capacityReservation(
    name: String,
    block: suspend CapacityReservationResourceBuilder.() -> Unit,
): CapacityReservation {
    val builder = CapacityReservationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CapacityReservation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capacityReservation(name: String): CapacityReservation {
    val builder = CapacityReservationResourceBuilder()
    builder.name(name)
    return builder.build()
}
