@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.CapacityReservationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Ecs Capacity Reservation resource.
 * For information about Ecs Capacity Reservation and how to use it, see [What is Capacity Reservation](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createcapacityreservation).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.ecs.getInstanceTypes({
 *     instanceTypeFamily: "ecs.g5",
 * });
 * const defaultGetZones = _default.then(_default => alicloud.getZones({
 *     availableResourceCreation: "Instance",
 *     availableInstanceType: _default.ids?.[0],
 * }));
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultCapacityReservation = new alicloud.ecs.CapacityReservation("default", {
 *     description: "terraform-example",
 *     platform: "linux",
 *     capacityReservationName: "terraform-example",
 *     endTimeType: "Unlimited",
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 *     instanceAmount: 1,
 *     instanceType: _default.then(_default => _default.ids?.[0]),
 *     matchCriteria: "Open",
 *     tags: {
 *         Created: "terraform-example",
 *     },
 *     zoneIds: [defaultGetZones&#46;then(defaultGetZones => defaultGetZones&#46;zones?&#46;[0]?&#46;id)],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.get_instance_types(instance_type_family="ecs.g5")
 * default_get_zones = alicloud.get_zones(available_resource_creation="Instance",
 *     available_instance_type=default.ids[0])
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_capacity_reservation = alicloud.ecs.CapacityReservation("default",
 *     description="terraform-example",
 *     platform="linux",
 *     capacity_reservation_name="terraform-example",
 *     end_time_type="Unlimited",
 *     resource_group_id=default_get_resource_groups.ids[0],
 *     instance_amount=1,
 *     instance_type=default.ids[0],
 *     match_criteria="Open",
 *     tags={
 *         "Created": "terraform-example",
 *     },
 *     zone_ids=[default_get_zones&#46;zones[0]&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "ecs.g5",
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *         AvailableInstanceType = @default.Apply(getInstanceTypesResult => getInstanceTypesResult.Ids[0]),
 *     });
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultCapacityReservation = new AliCloud.Ecs.CapacityReservation("default", new()
 *     {
 *         Description = "terraform-example",
 *         Platform = "linux",
 *         CapacityReservationName = "terraform-example",
 *         EndTimeType = "Unlimited",
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *         InstanceAmount = 1,
 *         InstanceType = @default.Apply(@default => @default.Apply(getInstanceTypesResult => getInstanceTypesResult.Ids[0])),
 *         MatchCriteria = "Open",
 *         Tags =
 *         {
 *             { "Created", "terraform-example" },
 *         },
 *         ZoneIds = new[]
 *         {
 *             defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.g5"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 			AvailableInstanceType:     pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewCapacityReservation(ctx, "default", &ecs.CapacityReservationArgs{
 * 			Description:             pulumi.String("terraform-example"),
 * 			Platform:                pulumi.String("linux"),
 * 			CapacityReservationName: pulumi.String("terraform-example"),
 * 			EndTimeType:             pulumi.String("Unlimited"),
 * 			ResourceGroupId:         pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 			InstanceAmount:          pulumi.Int(1),
 * 			InstanceType:            pulumi.String(_default.Ids[0]),
 * 			MatchCriteria:           pulumi.String("Open"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("terraform-example"),
 * 			},
 * 			ZoneIds: pulumi.StringArray{
 * 				pulumi.String(defaultGetZones.Zones[0].Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ecs.CapacityReservation;
 * import com.pulumi.alicloud.ecs.CapacityReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .instanceTypeFamily("ecs.g5")
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .availableInstanceType(default_.ids()[0])
 *             .build());
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultCapacityReservation = new CapacityReservation("defaultCapacityReservation", CapacityReservationArgs.builder()
 *             .description("terraform-example")
 *             .platform("linux")
 *             .capacityReservationName("terraform-example")
 *             .endTimeType("Unlimited")
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .instanceAmount(1)
 *             .instanceType(default_.ids()[0])
 *             .matchCriteria("Open")
 *             .tags(Map.of("Created", "terraform-example"))
 *             .zoneIds(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultCapacityReservation:
 *     type: alicloud:ecs:CapacityReservation
 *     name: default
 *     properties:
 *       description: terraform-example
 *       platform: linux
 *       capacityReservationName: terraform-example
 *       endTimeType: Unlimited
 *       resourceGroupId: ${defaultGetResourceGroups.ids[0]}
 *       instanceAmount: 1
 *       instanceType: ${default.ids[0]}
 *       matchCriteria: Open
 *       tags:
 *         Created: terraform-example
 *       zoneIds:
 *         - ${defaultGetZones.zones[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         instanceTypeFamily: ecs.g5
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *         availableInstanceType: ${default.ids[0]}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ecs Capacity Reservation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/capacityReservation:CapacityReservation example <id>
 * ```
 * @property capacityReservationName Capacity reservation service name.
 * @property description description of the capacity reservation instance.
 * @property dryRun Specifies whether to pre-check the API request. Valid values: `true` and `false`.
 * @property endTime end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
 * @property endTimeType Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
 * @property instanceAmount The total number of instances that need to be reserved within the capacity reservation.
 * @property instanceType Instance type. Currently, you can only set the capacity reservation service for one instance type.
 * @property matchCriteria The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
 * @property platform platform of the capacity reservation, value range `windows`, `linux`.
 * @property resourceGroupId The resource group id.
 * @property tags The tag of the resource.
 * @property zoneIds The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
 */
public data class CapacityReservationArgs(
    public val capacityReservationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val endTime: Output<String>? = null,
    public val endTimeType: Output<String>? = null,
    public val instanceAmount: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val matchCriteria: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.CapacityReservationArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.CapacityReservationArgs =
        com.pulumi.alicloud.ecs.CapacityReservationArgs.builder()
            .capacityReservationName(capacityReservationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .endTimeType(endTimeType?.applyValue({ args0 -> args0 }))
            .instanceAmount(instanceAmount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .matchCriteria(matchCriteria?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneIds(zoneIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CapacityReservationArgs].
 */
@PulumiTagMarker
public class CapacityReservationArgsBuilder internal constructor() {
    private var capacityReservationName: Output<String>? = null

    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var endTime: Output<String>? = null

    private var endTimeType: Output<String>? = null

    private var instanceAmount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var matchCriteria: Output<String>? = null

    private var platform: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneIds: Output<List<String>>? = null

    /**
     * @param value Capacity reservation service name.
     */
    @JvmName("ltkhbcibyxauboxh")
    public suspend fun capacityReservationName(`value`: Output<String>) {
        this.capacityReservationName = value
    }

    /**
     * @param value description of the capacity reservation instance.
     */
    @JvmName("edplqmgltddkigfo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to pre-check the API request. Valid values: `true` and `false`.
     */
    @JvmName("rtthmdwxjuepccaq")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
     */
    @JvmName("argpptiyqtvcqoli")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
     */
    @JvmName("opqidldqqxidnbuo")
    public suspend fun endTimeType(`value`: Output<String>) {
        this.endTimeType = value
    }

    /**
     * @param value The total number of instances that need to be reserved within the capacity reservation.
     */
    @JvmName("xovumquorrhtgcqi")
    public suspend fun instanceAmount(`value`: Output<Int>) {
        this.instanceAmount = value
    }

    /**
     * @param value Instance type. Currently, you can only set the capacity reservation service for one instance type.
     */
    @JvmName("upaeompeblsuufet")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
     */
    @JvmName("bhkmwubiodewdhtl")
    public suspend fun matchCriteria(`value`: Output<String>) {
        this.matchCriteria = value
    }

    /**
     * @param value platform of the capacity reservation, value range `windows`, `linux`.
     */
    @JvmName("xuhbyurbjwiyxoln")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("dlonjylkjrgqulwt")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("wsqeoheavnbxmwkp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
     */
    @JvmName("iyhrywsvfaxkalnj")
    public suspend fun zoneIds(`value`: Output<List<String>>) {
        this.zoneIds = value
    }

    @JvmName("spjtqorgjhmtruah")
    public suspend fun zoneIds(vararg values: Output<String>) {
        this.zoneIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
     */
    @JvmName("nvhwpaxugqsqbncd")
    public suspend fun zoneIds(values: List<Output<String>>) {
        this.zoneIds = Output.all(values)
    }

    /**
     * @param value Capacity reservation service name.
     */
    @JvmName("fyfokddiffdeikrc")
    public suspend fun capacityReservationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationName = mapped
    }

    /**
     * @param value description of the capacity reservation instance.
     */
    @JvmName("acechspuohbggdhm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to pre-check the API request. Valid values: `true` and `false`.
     */
    @JvmName("kaeiffgirsenwfht")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
     */
    @JvmName("bfradpwqfggtaoio")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
     */
    @JvmName("qvteortewflwmamw")
    public suspend fun endTimeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTimeType = mapped
    }

    /**
     * @param value The total number of instances that need to be reserved within the capacity reservation.
     */
    @JvmName("rracefekoebogjyq")
    public suspend fun instanceAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceAmount = mapped
    }

    /**
     * @param value Instance type. Currently, you can only set the capacity reservation service for one instance type.
     */
    @JvmName("xduvjbtbycopmcfc")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
     */
    @JvmName("mvpixatshtwmewdp")
    public suspend fun matchCriteria(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchCriteria = mapped
    }

    /**
     * @param value platform of the capacity reservation, value range `windows`, `linux`.
     */
    @JvmName("vqsjhcponlrrxdvc")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("avcspsvldqxuqsrk")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("gaufhncjjdnxpvpq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("xdlegwtqdvynmwte")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
     */
    @JvmName("dxsmbxxurxhmeqfq")
    public suspend fun zoneIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneIds = mapped
    }

    /**
     * @param values The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
     */
    @JvmName("qfatkxplhhfsfkex")
    public suspend fun zoneIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneIds = mapped
    }

    internal fun build(): CapacityReservationArgs = CapacityReservationArgs(
        capacityReservationName = capacityReservationName,
        description = description,
        dryRun = dryRun,
        endTime = endTime,
        endTimeType = endTimeType,
        instanceAmount = instanceAmount,
        instanceType = instanceType,
        matchCriteria = matchCriteria,
        platform = platform,
        resourceGroupId = resourceGroupId,
        tags = tags,
        zoneIds = zoneIds,
    )
}
