@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Command].
 */
@PulumiTagMarker
public class CommandResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommandArgs = CommandArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommandArgsBuilder.() -> Unit) {
        val builder = CommandArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Command {
        val builtJavaResource = com.pulumi.alicloud.ecs.Command(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Command(builtJavaResource)
    }
}

/**
 * Provides a ECS Command resource.
 * For information about ECS Command and how to use it, see [What is Command](https://www.alibabacloud.com/help/en/doc-detail/64844.htm).
 * > **NOTE:** Available in v1.116.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.Command("example", {
 *     name: "tf-testAcc",
 *     commandContent: "bHMK",
 *     description: "For Terraform Test",
 *     type: "RunShellScript",
 *     workingDir: "/root",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.Command("example",
 *     name="tf-testAcc",
 *     command_content="bHMK",
 *     description="For Terraform Test",
 *     type="RunShellScript",
 *     working_dir="/root")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.Command("example", new()
 *     {
 *         Name = "tf-testAcc",
 *         CommandContent = "bHMK",
 *         Description = "For Terraform Test",
 *         Type = "RunShellScript",
 *         WorkingDir = "/root",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewCommand(ctx, "example", &ecs.CommandArgs{
 * 			Name:           pulumi.String("tf-testAcc"),
 * 			CommandContent: pulumi.String("bHMK"),
 * 			Description:    pulumi.String("For Terraform Test"),
 * 			Type:           pulumi.String("RunShellScript"),
 * 			WorkingDir:     pulumi.String("/root"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Command;
 * import com.pulumi.alicloud.ecs.CommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Command("example", CommandArgs.builder()
 *             .name("tf-testAcc")
 *             .commandContent("bHMK")
 *             .description("For Terraform Test")
 *             .type("RunShellScript")
 *             .workingDir("/root")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:Command
 *     properties:
 *       name: tf-testAcc
 *       commandContent: bHMK
 *       description: For Terraform Test
 *       type: RunShellScript
 *       workingDir: /root
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Command can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/command:Command example <id>
 * ```
 */
public class Command internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.Command,
) : KotlinCustomResource(javaResource, CommandMapper) {
    /**
     * The Base64-encoded content of the command.
     */
    public val commandContent: Output<String>
        get() = javaResource.commandContent().applyValue({ args0 -> args0 })

    /**
     * The description of command.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to use custom parameters in the command to be created. Default to: false.
     */
    public val enableParameter: Output<Boolean>?
        get() = javaResource.enableParameter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the command, which supports all character sets. It can be up to 128 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The timeout period that is specified for the command to be run on ECS instances. Unit: seconds. Default to: `60`.
     */
    public val timeout: Output<Int>?
        get() = javaResource.timeout().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The command type. Valid Values: `RunBatScript`, `RunPowerShellScript` and `RunShellScript`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The execution path of the command in the ECS instance.
     */
    public val workingDir: Output<String>?
        get() = javaResource.workingDir().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object CommandMapper : ResourceMapper<Command> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.Command::class == javaResource::class

    override fun map(javaResource: Resource): Command = Command(
        javaResource as
            com.pulumi.alicloud.ecs.Command,
    )
}

/**
 * @see [Command].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Command].
 */
public suspend fun command(name: String, block: suspend CommandResourceBuilder.() -> Unit): Command {
    val builder = CommandResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Command].
 * @param name The _unique_ name of the resulting resource.
 */
public fun command(name: String): Command {
    val builder = CommandResourceBuilder()
    builder.name(name)
    return builder.build()
}
