@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.CommandArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECS Command resource.
 * For information about ECS Command and how to use it, see [What is Command](https://www.alibabacloud.com/help/en/doc-detail/64844.htm).
 * > **NOTE:** Available in v1.116.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.Command("example", {
 *     name: "tf-testAcc",
 *     commandContent: "bHMK",
 *     description: "For Terraform Test",
 *     type: "RunShellScript",
 *     workingDir: "/root",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.Command("example",
 *     name="tf-testAcc",
 *     command_content="bHMK",
 *     description="For Terraform Test",
 *     type="RunShellScript",
 *     working_dir="/root")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.Command("example", new()
 *     {
 *         Name = "tf-testAcc",
 *         CommandContent = "bHMK",
 *         Description = "For Terraform Test",
 *         Type = "RunShellScript",
 *         WorkingDir = "/root",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewCommand(ctx, "example", &ecs.CommandArgs{
 * 			Name:           pulumi.String("tf-testAcc"),
 * 			CommandContent: pulumi.String("bHMK"),
 * 			Description:    pulumi.String("For Terraform Test"),
 * 			Type:           pulumi.String("RunShellScript"),
 * 			WorkingDir:     pulumi.String("/root"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Command;
 * import com.pulumi.alicloud.ecs.CommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Command("example", CommandArgs.builder()
 *             .name("tf-testAcc")
 *             .commandContent("bHMK")
 *             .description("For Terraform Test")
 *             .type("RunShellScript")
 *             .workingDir("/root")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:Command
 *     properties:
 *       name: tf-testAcc
 *       commandContent: bHMK
 *       description: For Terraform Test
 *       type: RunShellScript
 *       workingDir: /root
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Command can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/command:Command example <id>
 * ```
 * @property commandContent The Base64-encoded content of the command.
 * @property description The description of command.
 * @property enableParameter Specifies whether to use custom parameters in the command to be created. Default to: false.
 * @property name The name of the command, which supports all character sets. It can be up to 128 characters in length.
 * @property timeout The timeout period that is specified for the command to be run on ECS instances. Unit: seconds. Default to: `60`.
 * @property type The command type. Valid Values: `RunBatScript`, `RunPowerShellScript` and `RunShellScript`.
 * @property workingDir The execution path of the command in the ECS instance.
 */
public data class CommandArgs(
    public val commandContent: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enableParameter: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val timeout: Output<Int>? = null,
    public val type: Output<String>? = null,
    public val workingDir: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.CommandArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.CommandArgs =
        com.pulumi.alicloud.ecs.CommandArgs.builder()
            .commandContent(commandContent?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableParameter(enableParameter?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .workingDir(workingDir?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommandArgs].
 */
@PulumiTagMarker
public class CommandArgsBuilder internal constructor() {
    private var commandContent: Output<String>? = null

    private var description: Output<String>? = null

    private var enableParameter: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var type: Output<String>? = null

    private var workingDir: Output<String>? = null

    /**
     * @param value The Base64-encoded content of the command.
     */
    @JvmName("sionulnvaoasojvg")
    public suspend fun commandContent(`value`: Output<String>) {
        this.commandContent = value
    }

    /**
     * @param value The description of command.
     */
    @JvmName("swdfudqcbsmaivjj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to use custom parameters in the command to be created. Default to: false.
     */
    @JvmName("rcxlhvrlhrfqikvo")
    public suspend fun enableParameter(`value`: Output<Boolean>) {
        this.enableParameter = value
    }

    /**
     * @param value The name of the command, which supports all character sets. It can be up to 128 characters in length.
     */
    @JvmName("plsewtckguhbgsay")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The timeout period that is specified for the command to be run on ECS instances. Unit: seconds. Default to: `60`.
     */
    @JvmName("dfgrvcdioijkrrbr")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The command type. Valid Values: `RunBatScript`, `RunPowerShellScript` and `RunShellScript`.
     */
    @JvmName("qcoohcdiwnetbafg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The execution path of the command in the ECS instance.
     */
    @JvmName("upptlrkboswepgbn")
    public suspend fun workingDir(`value`: Output<String>) {
        this.workingDir = value
    }

    /**
     * @param value The Base64-encoded content of the command.
     */
    @JvmName("kqnvnlnaafwmxyts")
    public suspend fun commandContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandContent = mapped
    }

    /**
     * @param value The description of command.
     */
    @JvmName("miaiisxcfvkmunvn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to use custom parameters in the command to be created. Default to: false.
     */
    @JvmName("dsnkvdrvtcdbcgxp")
    public suspend fun enableParameter(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableParameter = mapped
    }

    /**
     * @param value The name of the command, which supports all character sets. It can be up to 128 characters in length.
     */
    @JvmName("rsoqwtiavgfguivf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The timeout period that is specified for the command to be run on ECS instances. Unit: seconds. Default to: `60`.
     */
    @JvmName("erdngfqxutscsanv")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The command type. Valid Values: `RunBatScript`, `RunPowerShellScript` and `RunShellScript`.
     */
    @JvmName("nqpcqqbglbnjoemg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The execution path of the command in the ECS instance.
     */
    @JvmName("lrrbnmcuoapdfdev")
    public suspend fun workingDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDir = mapped
    }

    internal fun build(): CommandArgs = CommandArgs(
        commandContent = commandContent,
        description = description,
        enableParameter = enableParameter,
        name = name,
        timeout = timeout,
        type = type,
        workingDir = workingDir,
    )
}
