@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CopyImage].
 */
@PulumiTagMarker
public class CopyImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CopyImageArgs = CopyImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CopyImageArgsBuilder.() -> Unit) {
        val builder = CopyImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CopyImage {
        val builtJavaResource = com.pulumi.alicloud.ecs.CopyImage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CopyImage(builtJavaResource)
    }
}

public class CopyImage internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.CopyImage,
) : KotlinCustomResource(javaResource, CopyImageMapper) {
    public val deleteAutoSnapshot: Output<Boolean>?
        get() = javaResource.deleteAutoSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val imageName: Output<String>
        get() = javaResource.imageName().applyValue({ args0 -> args0 })

    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    @Deprecated(
        message = """
  Attribute 'name' has been deprecated from version 1.69.0. Use `image_name` instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val sourceImageId: Output<String>
        get() = javaResource.sourceImageId().applyValue({ args0 -> args0 })

    public val sourceRegionId: Output<String>
        get() = javaResource.sourceRegionId().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object CopyImageMapper : ResourceMapper<CopyImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.CopyImage::class == javaResource::class

    override fun map(javaResource: Resource): CopyImage = CopyImage(
        javaResource as
            com.pulumi.alicloud.ecs.CopyImage,
    )
}

/**
 * @see [CopyImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CopyImage].
 */
public suspend fun copyImage(name: String, block: suspend CopyImageResourceBuilder.() -> Unit): CopyImage {
    val builder = CopyImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CopyImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun copyImage(name: String): CopyImage {
    val builder = CopyImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
