@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.CopyImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property deleteAutoSnapshot
 * @property description
 * @property encrypted
 * @property force
 * @property imageName
 * @property kmsKeyId
 * @property name
 * @property sourceImageId
 * @property sourceRegionId
 * @property tags
 */
public data class CopyImageArgs(
    public val deleteAutoSnapshot: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val force: Output<Boolean>? = null,
    public val imageName: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute 'name' has been deprecated from version 1.69.0. Use `image_name` instead.
  """,
    )
    public val name: Output<String>? = null,
    public val sourceImageId: Output<String>? = null,
    public val sourceRegionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.CopyImageArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.CopyImageArgs =
        com.pulumi.alicloud.ecs.CopyImageArgs.builder()
            .deleteAutoSnapshot(deleteAutoSnapshot?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceImageId(sourceImageId?.applyValue({ args0 -> args0 }))
            .sourceRegionId(sourceRegionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CopyImageArgs].
 */
@PulumiTagMarker
public class CopyImageArgsBuilder internal constructor() {
    private var deleteAutoSnapshot: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var force: Output<Boolean>? = null

    private var imageName: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var sourceImageId: Output<String>? = null

    private var sourceRegionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("dxjfyfhrcfnfgcmw")
    public suspend fun deleteAutoSnapshot(`value`: Output<Boolean>) {
        this.deleteAutoSnapshot = value
    }

    /**
     * @param value
     */
    @JvmName("hfmcxmpdbtppkfii")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("wrxiteravxvswogw")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value
     */
    @JvmName("rlxcxcqwpocrkaby")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value
     */
    @JvmName("yvpkndsdhwwajyrw")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value
     */
    @JvmName("rqgywdtmalnkgxwk")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Attribute 'name' has been deprecated from version 1.69.0. Use `image_name` instead.
  """,
    )
    @JvmName("hilocfilrlyhafyh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("bjjuynbtwuqmgvlr")
    public suspend fun sourceImageId(`value`: Output<String>) {
        this.sourceImageId = value
    }

    /**
     * @param value
     */
    @JvmName("thfjrbdmfinywbqj")
    public suspend fun sourceRegionId(`value`: Output<String>) {
        this.sourceRegionId = value
    }

    /**
     * @param value
     */
    @JvmName("uprjmdjnhocfohmt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("rqiqcurllcgwtwwn")
    public suspend fun deleteAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAutoSnapshot = mapped
    }

    /**
     * @param value
     */
    @JvmName("srikgctgxfnbfigr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("hkciltqnhkhwlruc")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value
     */
    @JvmName("juiunqkgatplienb")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value
     */
    @JvmName("isqekbdmnokyetqr")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value
     */
    @JvmName("hbawpstwadlbaaof")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Attribute 'name' has been deprecated from version 1.69.0. Use `image_name` instead.
  """,
    )
    @JvmName("hmjvkuxjkbhdokfh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("bekmbmwospxrfocd")
    public suspend fun sourceImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceImageId = mapped
    }

    /**
     * @param value
     */
    @JvmName("sgkhyuicwcokxoeu")
    public suspend fun sourceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRegionId = mapped
    }

    /**
     * @param value
     */
    @JvmName("nseibygwurulldca")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("fpkykftoehwivemk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CopyImageArgs = CopyImageArgs(
        deleteAutoSnapshot = deleteAutoSnapshot,
        description = description,
        encrypted = encrypted,
        force = force,
        imageName = imageName,
        kmsKeyId = kmsKeyId,
        name = name,
        sourceImageId = sourceImageId,
        sourceRegionId = sourceRegionId,
        tags = tags,
    )
}
