@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.DedicatedHostNetworkAttribute
import com.pulumi.alicloud.ecs.kotlin.outputs.DedicatedHostNetworkAttribute.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DedicatedHost].
 */
@PulumiTagMarker
public class DedicatedHostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedHostArgs = DedicatedHostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedHostArgsBuilder.() -> Unit) {
        val builder = DedicatedHostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedHost {
        val builtJavaResource = com.pulumi.alicloud.ecs.DedicatedHost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedHost(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Ecs dedicated host can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/dedicatedHost:DedicatedHost default dh-2zedmxxxx
 * ```
 */
public class DedicatedHost internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.DedicatedHost,
) : KotlinCustomResource(javaResource, DedicatedHostMapper) {
    /**
     * The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
     */
    public val actionOnMaintenance: Output<String>?
        get() = javaResource.actionOnMaintenance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
     */
    public val autoPlacement: Output<String>?
        get() = javaResource.autoPlacement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
     */
    public val autoReleaseTime: Output<String>
        get() = javaResource.autoReleaseTime().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to automatically renew the subscription dedicated host.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
     */
    public val cpuOverCommitRatio: Output<Double>?
        get() = javaResource.cpuOverCommitRatio().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dedicated host cluster ID to which the dedicated host belongs.
     */
    public val dedicatedHostClusterId: Output<String>?
        get() = javaResource.dedicatedHostClusterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    public val dedicatedHostName: Output<String>?
        get() = javaResource.dedicatedHostName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
     */
    public val dedicatedHostType: Output<String>
        get() = javaResource.dedicatedHostType().applyValue({ args0 -> args0 })

    /**
     * The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
     */
    public val detailFee: Output<Boolean>?
        get() = javaResource.detailFee().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to only validate the request. Default: `false`.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
     */
    public val expiredTime: Output<String>
        get() = javaResource.expiredTime().applyValue({ args0 -> args0 })

    /**
     * Specify the minimum purchase quantity of a dedicated host.
     */
    public val minQuantity: Output<Int>?
        get() = javaResource.minQuantity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * dedicated host network parameters. contains the following attributes:
     */
    public val networkAttributes: Output<List<DedicatedHostNetworkAttribute>>?
        get() = javaResource.networkAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group to which the dedicated host belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The unit of the subscription period of the dedicated host.
     */
    public val saleCycle: Output<String>
        get() = javaResource.saleCycle().applyValue({ args0 -> args0 })

    /**
     * The status of the dedicated host.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DedicatedHostMapper : ResourceMapper<DedicatedHost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.DedicatedHost::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedHost = DedicatedHost(
        javaResource as
            com.pulumi.alicloud.ecs.DedicatedHost,
    )
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedHost].
 */
public suspend fun dedicatedHost(
    name: String,
    block: suspend DedicatedHostResourceBuilder.() -> Unit,
): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedHost(name: String): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    return builder.build()
}
