@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.DedicatedHostArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.DedicatedHostNetworkAttributeArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.DedicatedHostNetworkAttributeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Ecs dedicated host can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/dedicatedHost:DedicatedHost default dh-2zedmxxxx
 * ```
 * @property actionOnMaintenance The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
 * @property autoPlacement Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
 * @property autoReleaseTime The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
 * @property autoRenew Specifies whether to automatically renew the subscription dedicated host.
 * @property autoRenewPeriod The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
 * @property cpuOverCommitRatio CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
 * @property dedicatedHostClusterId The dedicated host cluster ID to which the dedicated host belongs.
 * @property dedicatedHostName The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
 * @property dedicatedHostType The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
 * @property description The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
 * @property detailFee Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
 * @property dryRun Specifies whether to only validate the request. Default: `false`.
 * @property expiredTime The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
 * @property minQuantity Specify the minimum purchase quantity of a dedicated host.
 * @property networkAttributes dedicated host network parameters. contains the following attributes:
 * @property paymentType The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
 * @property resourceGroupId The ID of the resource group to which the dedicated host belongs.
 * @property saleCycle The unit of the subscription period of the dedicated host.
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
 */
public data class DedicatedHostArgs(
    public val actionOnMaintenance: Output<String>? = null,
    public val autoPlacement: Output<String>? = null,
    public val autoReleaseTime: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val cpuOverCommitRatio: Output<Double>? = null,
    public val dedicatedHostClusterId: Output<String>? = null,
    public val dedicatedHostName: Output<String>? = null,
    public val dedicatedHostType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val detailFee: Output<Boolean>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val expiredTime: Output<String>? = null,
    public val minQuantity: Output<Int>? = null,
    public val networkAttributes: Output<List<DedicatedHostNetworkAttributeArgs>>? = null,
    public val paymentType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val saleCycle: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.DedicatedHostArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.DedicatedHostArgs =
        com.pulumi.alicloud.ecs.DedicatedHostArgs.builder()
            .actionOnMaintenance(actionOnMaintenance?.applyValue({ args0 -> args0 }))
            .autoPlacement(autoPlacement?.applyValue({ args0 -> args0 }))
            .autoReleaseTime(autoReleaseTime?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .cpuOverCommitRatio(cpuOverCommitRatio?.applyValue({ args0 -> args0 }))
            .dedicatedHostClusterId(dedicatedHostClusterId?.applyValue({ args0 -> args0 }))
            .dedicatedHostName(dedicatedHostName?.applyValue({ args0 -> args0 }))
            .dedicatedHostType(dedicatedHostType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .detailFee(detailFee?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .expiredTime(expiredTime?.applyValue({ args0 -> args0 }))
            .minQuantity(minQuantity?.applyValue({ args0 -> args0 }))
            .networkAttributes(
                networkAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .saleCycle(saleCycle?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedHostArgs].
 */
@PulumiTagMarker
public class DedicatedHostArgsBuilder internal constructor() {
    private var actionOnMaintenance: Output<String>? = null

    private var autoPlacement: Output<String>? = null

    private var autoReleaseTime: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var cpuOverCommitRatio: Output<Double>? = null

    private var dedicatedHostClusterId: Output<String>? = null

    private var dedicatedHostName: Output<String>? = null

    private var dedicatedHostType: Output<String>? = null

    private var description: Output<String>? = null

    private var detailFee: Output<Boolean>? = null

    private var dryRun: Output<Boolean>? = null

    private var expiredTime: Output<String>? = null

    private var minQuantity: Output<Int>? = null

    private var networkAttributes: Output<List<DedicatedHostNetworkAttributeArgs>>? = null

    private var paymentType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var saleCycle: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
     */
    @JvmName("hladukqacnowrahv")
    public suspend fun actionOnMaintenance(`value`: Output<String>) {
        this.actionOnMaintenance = value
    }

    /**
     * @param value Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
     */
    @JvmName("cdwtrfrxnhqbpuoj")
    public suspend fun autoPlacement(`value`: Output<String>) {
        this.autoPlacement = value
    }

    /**
     * @param value The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
     */
    @JvmName("dxumkpwqipbhovpy")
    public suspend fun autoReleaseTime(`value`: Output<String>) {
        this.autoReleaseTime = value
    }

    /**
     * @param value Specifies whether to automatically renew the subscription dedicated host.
     */
    @JvmName("voxtubtariihohbd")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
     */
    @JvmName("iqgaajrtsmyicceo")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
     */
    @JvmName("aenuyshvombrrmrx")
    public suspend fun cpuOverCommitRatio(`value`: Output<Double>) {
        this.cpuOverCommitRatio = value
    }

    /**
     * @param value The dedicated host cluster ID to which the dedicated host belongs.
     */
    @JvmName("isstqvqhcsxhcfvs")
    public suspend fun dedicatedHostClusterId(`value`: Output<String>) {
        this.dedicatedHostClusterId = value
    }

    /**
     * @param value The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("bsiipjpvyyeatymu")
    public suspend fun dedicatedHostName(`value`: Output<String>) {
        this.dedicatedHostName = value
    }

    /**
     * @param value The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
     */
    @JvmName("suqpjfdndoeybmog")
    public suspend fun dedicatedHostType(`value`: Output<String>) {
        this.dedicatedHostType = value
    }

    /**
     * @param value The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("vuygsgxvcnaxyijf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
     */
    @JvmName("huxvsrdfdqwishhw")
    public suspend fun detailFee(`value`: Output<Boolean>) {
        this.detailFee = value
    }

    /**
     * @param value Specifies whether to only validate the request. Default: `false`.
     */
    @JvmName("qmyylvkjgignnqpw")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
     */
    @JvmName("jsknpspxdnhqvhmo")
    public suspend fun expiredTime(`value`: Output<String>) {
        this.expiredTime = value
    }

    /**
     * @param value Specify the minimum purchase quantity of a dedicated host.
     */
    @JvmName("fwuaenaikwcubgtv")
    public suspend fun minQuantity(`value`: Output<Int>) {
        this.minQuantity = value
    }

    /**
     * @param value dedicated host network parameters. contains the following attributes:
     */
    @JvmName("qkjchqiygjfufose")
    public suspend fun networkAttributes(`value`: Output<List<DedicatedHostNetworkAttributeArgs>>) {
        this.networkAttributes = value
    }

    @JvmName("nmxtrampdwjkhbhe")
    public suspend fun networkAttributes(vararg values: Output<DedicatedHostNetworkAttributeArgs>) {
        this.networkAttributes = Output.all(values.asList())
    }

    /**
     * @param values dedicated host network parameters. contains the following attributes:
     */
    @JvmName("uqdrtaqpbpwrlbxc")
    public suspend fun networkAttributes(values: List<Output<DedicatedHostNetworkAttributeArgs>>) {
        this.networkAttributes = Output.all(values)
    }

    /**
     * @param value The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
     */
    @JvmName("boeuhwassdhlsjso")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The ID of the resource group to which the dedicated host belongs.
     */
    @JvmName("lruspgnvlbhaqlsh")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The unit of the subscription period of the dedicated host.
     */
    @JvmName("lnvygyvcowwcivje")
    public suspend fun saleCycle(`value`: Output<String>) {
        this.saleCycle = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("bhpwgxxcbxjvkcsg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
     */
    @JvmName("upsputicysjjquxe")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
     */
    @JvmName("tlhvkuhxbeibvffg")
    public suspend fun actionOnMaintenance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionOnMaintenance = mapped
    }

    /**
     * @param value Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
     */
    @JvmName("qoebxmegsqgmrfpc")
    public suspend fun autoPlacement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPlacement = mapped
    }

    /**
     * @param value The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
     */
    @JvmName("pefcvykjfuncrwqq")
    public suspend fun autoReleaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoReleaseTime = mapped
    }

    /**
     * @param value Specifies whether to automatically renew the subscription dedicated host.
     */
    @JvmName("ujptysqflkgernlh")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
     */
    @JvmName("atqhvuwmigwdirbf")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
     */
    @JvmName("ouwtutxsrdnoqwya")
    public suspend fun cpuOverCommitRatio(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuOverCommitRatio = mapped
    }

    /**
     * @param value The dedicated host cluster ID to which the dedicated host belongs.
     */
    @JvmName("swgjeyvxpgliyflh")
    public suspend fun dedicatedHostClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostClusterId = mapped
    }

    /**
     * @param value The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("ctjsoodydkduedpe")
    public suspend fun dedicatedHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostName = mapped
    }

    /**
     * @param value The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
     */
    @JvmName("wpkddkgqiuhdoqst")
    public suspend fun dedicatedHostType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostType = mapped
    }

    /**
     * @param value The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("lqeciuwakrjoreff")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
     */
    @JvmName("tknapccygqgljaei")
    public suspend fun detailFee(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailFee = mapped
    }

    /**
     * @param value Specifies whether to only validate the request. Default: `false`.
     */
    @JvmName("bmojulisltfqtanb")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
     */
    @JvmName("rbljxfxdwxjldiem")
    public suspend fun expiredTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiredTime = mapped
    }

    /**
     * @param value Specify the minimum purchase quantity of a dedicated host.
     */
    @JvmName("dhfrunmauyarccnv")
    public suspend fun minQuantity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minQuantity = mapped
    }

    /**
     * @param value dedicated host network parameters. contains the following attributes:
     */
    @JvmName("wcdqhixbnyntbshc")
    public suspend fun networkAttributes(`value`: List<DedicatedHostNetworkAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAttributes = mapped
    }

    /**
     * @param argument dedicated host network parameters. contains the following attributes:
     */
    @JvmName("sswsjamvfihigjqp")
    public suspend fun networkAttributes(argument: List<suspend DedicatedHostNetworkAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DedicatedHostNetworkAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkAttributes = mapped
    }

    /**
     * @param argument dedicated host network parameters. contains the following attributes:
     */
    @JvmName("kqmwmotftrwpflwl")
    public suspend fun networkAttributes(vararg argument: suspend DedicatedHostNetworkAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DedicatedHostNetworkAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkAttributes = mapped
    }

    /**
     * @param argument dedicated host network parameters. contains the following attributes:
     */
    @JvmName("fmtmlbudogawciqr")
    public suspend fun networkAttributes(argument: suspend DedicatedHostNetworkAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DedicatedHostNetworkAttributeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkAttributes = mapped
    }

    /**
     * @param values dedicated host network parameters. contains the following attributes:
     */
    @JvmName("suvldhlilcppptwf")
    public suspend fun networkAttributes(vararg values: DedicatedHostNetworkAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAttributes = mapped
    }

    /**
     * @param value The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
     */
    @JvmName("juihdplprxrrjkbt")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The ID of the resource group to which the dedicated host belongs.
     */
    @JvmName("hofikxpqdigqodrv")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The unit of the subscription period of the dedicated host.
     */
    @JvmName("qhhlnlrlrrnqtmda")
    public suspend fun saleCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saleCycle = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("piasodvgbxgnxptt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ovbknurabumnbdmd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
     */
    @JvmName("yfnsiduacocqnyqc")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DedicatedHostArgs = DedicatedHostArgs(
        actionOnMaintenance = actionOnMaintenance,
        autoPlacement = autoPlacement,
        autoReleaseTime = autoReleaseTime,
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        cpuOverCommitRatio = cpuOverCommitRatio,
        dedicatedHostClusterId = dedicatedHostClusterId,
        dedicatedHostName = dedicatedHostName,
        dedicatedHostType = dedicatedHostType,
        description = description,
        detailFee = detailFee,
        dryRun = dryRun,
        expiredTime = expiredTime,
        minQuantity = minQuantity,
        networkAttributes = networkAttributes,
        paymentType = paymentType,
        resourceGroupId = resourceGroupId,
        saleCycle = saleCycle,
        tags = tags,
        zoneId = zoneId,
    )
}
