@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Disk].
 */
@PulumiTagMarker
public class DiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskArgs = DiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskArgsBuilder.() -> Unit) {
        val builder = DiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Disk {
        val builtJavaResource = com.pulumi.alicloud.ecs.Disk(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk(builtJavaResource)
    }
}

/**
 * Provides a ECS disk resource.
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsDisk from version 1.122.0.
 * > **NOTE:** One of `size` or `snapshot_id` is required when specifying an ECS disk. If all of them be specified, `size` must more than the size of snapshot which `snapshot_id` represents. Currently, `alicloud.ecs.Disk` doesn't resize disk.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new ECS disk.
 * const ecsDisk = new alicloud.ecs.Disk("ecs_disk", {
 *     availabilityZone: "cn-beijing-b",
 *     name: "New-disk",
 *     description: "Hello ecs disk.",
 *     category: "cloud_efficiency",
 *     size: 30,
 *     encrypted: true,
 *     kmsKeyId: "2a6767f0-a16c-4679-a60f-13bf*****",
 *     tags: {
 *         Name: "TerraformTest",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new ECS disk.
 * ecs_disk = alicloud.ecs.Disk("ecs_disk",
 *     availability_zone="cn-beijing-b",
 *     name="New-disk",
 *     description="Hello ecs disk.",
 *     category="cloud_efficiency",
 *     size=30,
 *     encrypted=True,
 *     kms_key_id="2a6767f0-a16c-4679-a60f-13bf*****",
 *     tags={
 *         "Name": "TerraformTest",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new ECS disk.
 *     var ecsDisk = new AliCloud.Ecs.Disk("ecs_disk", new()
 *     {
 *         AvailabilityZone = "cn-beijing-b",
 *         Name = "New-disk",
 *         Description = "Hello ecs disk.",
 *         Category = "cloud_efficiency",
 *         Size = 30,
 *         Encrypted = true,
 *         KmsKeyId = "2a6767f0-a16c-4679-a60f-13bf*****",
 *         Tags =
 *         {
 *             { "Name", "TerraformTest" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new ECS disk.
 * 		_, err := ecs.NewDisk(ctx, "ecs_disk", &ecs.DiskArgs{
 * 			AvailabilityZone: pulumi.String("cn-beijing-b"),
 * 			Name:             pulumi.String("New-disk"),
 * 			Description:      pulumi.String("Hello ecs disk."),
 * 			Category:         pulumi.String("cloud_efficiency"),
 * 			Size:             pulumi.Int(30),
 * 			Encrypted:        pulumi.Bool(true),
 * 			KmsKeyId:         pulumi.String("2a6767f0-a16c-4679-a60f-13bf*****"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("TerraformTest"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Disk;
 * import com.pulumi.alicloud.ecs.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new ECS disk.
 *         var ecsDisk = new Disk("ecsDisk", DiskArgs.builder()
 *             .availabilityZone("cn-beijing-b")
 *             .name("New-disk")
 *             .description("Hello ecs disk.")
 *             .category("cloud_efficiency")
 *             .size("30")
 *             .encrypted(true)
 *             .kmsKeyId("2a6767f0-a16c-4679-a60f-13bf*****")
 *             .tags(Map.of("Name", "TerraformTest"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new ECS disk.
 *   ecsDisk:
 *     type: alicloud:ecs:Disk
 *     name: ecs_disk
 *     properties:
 *       availabilityZone: cn-beijing-b
 *       name: New-disk
 *       description: Hello ecs disk.
 *       category: cloud_efficiency
 *       size: '30'
 *       encrypted: true
 *       kmsKeyId: 2a6767f0-a16c-4679-a60f-13bf*****
 *       tags:
 *         Name: TerraformTest
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/disk:Disk example d-abc12345678
 * ```
 */
public class Disk internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.Disk,
) : KotlinCustomResource(javaResource, DiskMapper) {
    public val advancedFeatures: Output<String>?
        get() = javaResource.advancedFeatures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Zone to create the disk in.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_entry`. Default is `cloud_efficiency`.
     */
    public val category: Output<String>?
        get() = javaResource.category().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether the automatic snapshot is deleted when the disk is released. Default value: false.
     */
    public val deleteAutoSnapshot: Output<Boolean>?
        get() = javaResource.deleteAutoSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the disk is released together with the instance: Default value: false.
     */
    public val deleteWithInstance: Output<Boolean>
        get() = javaResource.deleteWithInstance().applyValue({ args0 -> args0 })

    /**
     * Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val diskName: Output<String>
        get() = javaResource.diskName().applyValue({ args0 -> args0 })

    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether to apply a created automatic snapshot policy to the disk. Default value: false.
     */
    public val enableAutoSnapshot: Output<Boolean>
        get() = javaResource.enableAutoSnapshot().applyValue({ args0 -> args0 })

    public val encryptAlgorithm: Output<String>?
        get() = javaResource.encryptAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, the disk will be encrypted, conflict with `snapshot_id`.
     */
    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Specifies the performance level of an ESSD when you create the ESSD. Default value: `PL1`. Valid values:
     * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
     */
    public val performanceLevel: Output<String>
        get() = javaResource.performanceLevel().applyValue({ args0 -> args0 })

    /**
     * The Id of resource group which the disk belongs.
     * > **NOTE:** Disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
     */
    public val size: Output<Int>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
     */
    public val snapshotId: Output<String>?
        get() = javaResource.snapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The disk status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val storageSetId: Output<String>?
        get() = javaResource.storageSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val storageSetPartitionNumber: Output<Int>?
        get() = javaResource.storageSetPartitionNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DiskMapper : ResourceMapper<Disk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.Disk::class == javaResource::class

    override fun map(javaResource: Resource): Disk = Disk(
        javaResource as
            com.pulumi.alicloud.ecs.Disk,
    )
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk].
 */
public suspend fun disk(name: String, block: suspend DiskResourceBuilder.() -> Unit): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk(name: String): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
