@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.DiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS disk resource.
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsDisk from version 1.122.0.
 * > **NOTE:** One of `size` or `snapshot_id` is required when specifying an ECS disk. If all of them be specified, `size` must more than the size of snapshot which `snapshot_id` represents. Currently, `alicloud.ecs.Disk` doesn't resize disk.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new ECS disk.
 * const ecsDisk = new alicloud.ecs.Disk("ecs_disk", {
 *     availabilityZone: "cn-beijing-b",
 *     name: "New-disk",
 *     description: "Hello ecs disk.",
 *     category: "cloud_efficiency",
 *     size: 30,
 *     encrypted: true,
 *     kmsKeyId: "2a6767f0-a16c-4679-a60f-13bf*****",
 *     tags: {
 *         Name: "TerraformTest",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new ECS disk.
 * ecs_disk = alicloud.ecs.Disk("ecs_disk",
 *     availability_zone="cn-beijing-b",
 *     name="New-disk",
 *     description="Hello ecs disk.",
 *     category="cloud_efficiency",
 *     size=30,
 *     encrypted=True,
 *     kms_key_id="2a6767f0-a16c-4679-a60f-13bf*****",
 *     tags={
 *         "Name": "TerraformTest",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new ECS disk.
 *     var ecsDisk = new AliCloud.Ecs.Disk("ecs_disk", new()
 *     {
 *         AvailabilityZone = "cn-beijing-b",
 *         Name = "New-disk",
 *         Description = "Hello ecs disk.",
 *         Category = "cloud_efficiency",
 *         Size = 30,
 *         Encrypted = true,
 *         KmsKeyId = "2a6767f0-a16c-4679-a60f-13bf*****",
 *         Tags =
 *         {
 *             { "Name", "TerraformTest" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new ECS disk.
 * 		_, err := ecs.NewDisk(ctx, "ecs_disk", &ecs.DiskArgs{
 * 			AvailabilityZone: pulumi.String("cn-beijing-b"),
 * 			Name:             pulumi.String("New-disk"),
 * 			Description:      pulumi.String("Hello ecs disk."),
 * 			Category:         pulumi.String("cloud_efficiency"),
 * 			Size:             pulumi.Int(30),
 * 			Encrypted:        pulumi.Bool(true),
 * 			KmsKeyId:         pulumi.String("2a6767f0-a16c-4679-a60f-13bf*****"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("TerraformTest"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Disk;
 * import com.pulumi.alicloud.ecs.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new ECS disk.
 *         var ecsDisk = new Disk("ecsDisk", DiskArgs.builder()
 *             .availabilityZone("cn-beijing-b")
 *             .name("New-disk")
 *             .description("Hello ecs disk.")
 *             .category("cloud_efficiency")
 *             .size("30")
 *             .encrypted(true)
 *             .kmsKeyId("2a6767f0-a16c-4679-a60f-13bf*****")
 *             .tags(Map.of("Name", "TerraformTest"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new ECS disk.
 *   ecsDisk:
 *     type: alicloud:ecs:Disk
 *     name: ecs_disk
 *     properties:
 *       availabilityZone: cn-beijing-b
 *       name: New-disk
 *       description: Hello ecs disk.
 *       category: cloud_efficiency
 *       size: '30'
 *       encrypted: true
 *       kmsKeyId: 2a6767f0-a16c-4679-a60f-13bf*****
 *       tags:
 *         Name: TerraformTest
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/disk:Disk example d-abc12345678
 * ```
 * @property advancedFeatures
 * @property availabilityZone The Zone to create the disk in.
 * @property category Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_entry`. Default is `cloud_efficiency`.
 * @property deleteAutoSnapshot Indicates whether the automatic snapshot is deleted when the disk is released. Default value: false.
 * @property deleteWithInstance Indicates whether the disk is released together with the instance: Default value: false.
 * @property description Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
 * @property diskName
 * @property dryRun
 * @property enableAutoSnapshot Indicates whether to apply a created automatic snapshot policy to the disk. Default value: false.
 * @property encryptAlgorithm
 * @property encrypted If true, the disk will be encrypted, conflict with `snapshot_id`.
 * @property instanceId
 * @property kmsKeyId The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
 * @property name Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
 * @property paymentType
 * @property performanceLevel Specifies the performance level of an ESSD when you create the ESSD. Default value: `PL1`. Valid values:
 * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
 * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
 * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
 * @property resourceGroupId The Id of resource group which the disk belongs.
 * > **NOTE:** Disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
 * @property size The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
 * @property snapshotId A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
 * @property storageSetId
 * @property storageSetPartitionNumber
 * @property tags A mapping of tags to assign to the resource.
 * @property type
 * @property zoneId
 */
public data class DiskArgs(
    public val advancedFeatures: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    public val availabilityZone: Output<String>? = null,
    public val category: Output<String>? = null,
    public val deleteAutoSnapshot: Output<Boolean>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val diskName: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val enableAutoSnapshot: Output<Boolean>? = null,
    public val encryptAlgorithm: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
    public val storageSetId: Output<String>? = null,
    public val storageSetPartitionNumber: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.DiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.DiskArgs =
        com.pulumi.alicloud.ecs.DiskArgs.builder()
            .advancedFeatures(advancedFeatures?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteAutoSnapshot(deleteAutoSnapshot?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .enableAutoSnapshot(enableAutoSnapshot?.applyValue({ args0 -> args0 }))
            .encryptAlgorithm(encryptAlgorithm?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .storageSetId(storageSetId?.applyValue({ args0 -> args0 }))
            .storageSetPartitionNumber(storageSetPartitionNumber?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var advancedFeatures: Output<String>? = null

    private var availabilityZone: Output<String>? = null

    private var category: Output<String>? = null

    private var deleteAutoSnapshot: Output<Boolean>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var diskName: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var enableAutoSnapshot: Output<Boolean>? = null

    private var encryptAlgorithm: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    private var storageSetId: Output<String>? = null

    private var storageSetPartitionNumber: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("kalbxwpntxwxcuow")
    public suspend fun advancedFeatures(`value`: Output<String>) {
        this.advancedFeatures = value
    }

    /**
     * @param value The Zone to create the disk in.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    @JvmName("xsxvtfqagpykjskr")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_entry`. Default is `cloud_efficiency`.
     */
    @JvmName("kqyftrpalyvtiwlv")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Indicates whether the automatic snapshot is deleted when the disk is released. Default value: false.
     */
    @JvmName("vamkicivsxwxqrbt")
    public suspend fun deleteAutoSnapshot(`value`: Output<Boolean>) {
        this.deleteAutoSnapshot = value
    }

    /**
     * @param value Indicates whether the disk is released together with the instance: Default value: false.
     */
    @JvmName("ukqgwpdjbvfafidl")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("cbkdxvuopvrlwixh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("rtqceokuwvmwrcus")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value
     */
    @JvmName("xkhvfescgyospcog")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value Indicates whether to apply a created automatic snapshot policy to the disk. Default value: false.
     */
    @JvmName("hwydyoyebadkjoby")
    public suspend fun enableAutoSnapshot(`value`: Output<Boolean>) {
        this.enableAutoSnapshot = value
    }

    /**
     * @param value
     */
    @JvmName("jwluuqwbatyfmyur")
    public suspend fun encryptAlgorithm(`value`: Output<String>) {
        this.encryptAlgorithm = value
    }

    /**
     * @param value If true, the disk will be encrypted, conflict with `snapshot_id`.
     */
    @JvmName("mtekvdtdwwcmxyrg")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value
     */
    @JvmName("kgdshdmeqldeljum")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
     */
    @JvmName("ugerwqvfxpxmbcxk")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    @JvmName("prqtundxxlmugkmm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("eijjfwssdyejimpy")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Specifies the performance level of an ESSD when you create the ESSD. Default value: `PL1`. Valid values:
     * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
     */
    @JvmName("rithyqsujqhgthfi")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The Id of resource group which the disk belongs.
     * > **NOTE:** Disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
     */
    @JvmName("vduudvflsabcylmn")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
     */
    @JvmName("wtocbqbcujxkrnqa")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
     */
    @JvmName("ppepiemolibsknxb")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value
     */
    @JvmName("uaaqbwnyiwnebeym")
    public suspend fun storageSetId(`value`: Output<String>) {
        this.storageSetId = value
    }

    /**
     * @param value
     */
    @JvmName("ydvjvifqhgvaekwh")
    public suspend fun storageSetPartitionNumber(`value`: Output<Int>) {
        this.storageSetPartitionNumber = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("nkixjnuyeriibxyg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("vgxbofbtyullpxwu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("rjlalgqwsturterq")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value
     */
    @JvmName("sfiuodfqetqptpna")
    public suspend fun advancedFeatures(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedFeatures = mapped
    }

    /**
     * @param value The Zone to create the disk in.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    @JvmName("magotlysubxxyila")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_entry`. Default is `cloud_efficiency`.
     */
    @JvmName("gmyfcplgldujvjeo")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Indicates whether the automatic snapshot is deleted when the disk is released. Default value: false.
     */
    @JvmName("idqniajtxpsirgjt")
    public suspend fun deleteAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAutoSnapshot = mapped
    }

    /**
     * @param value Indicates whether the disk is released together with the instance: Default value: false.
     */
    @JvmName("xyacvqcjbqamajas")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("wkhewvktstynbkpr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("amalhpfeaqcstyvc")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tjcivmrvwmbiqfle")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value Indicates whether to apply a created automatic snapshot policy to the disk. Default value: false.
     */
    @JvmName("povjclrdcpfwjpae")
    public suspend fun enableAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoSnapshot = mapped
    }

    /**
     * @param value
     */
    @JvmName("afqqodbpagcidypo")
    public suspend fun encryptAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptAlgorithm = mapped
    }

    /**
     * @param value If true, the disk will be encrypted, conflict with `snapshot_id`.
     */
    @JvmName("ynxtbffwlsmalskh")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value
     */
    @JvmName("xshumifnlyauylgh")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
     */
    @JvmName("eqkdogevfoilavou")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Default value is null.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    @JvmName("lupfucmqglhwxomp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ljnbryfmiprecawc")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Specifies the performance level of an ESSD when you create the ESSD. Default value: `PL1`. Valid values:
     * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
     */
    @JvmName("dkniynadulehgeou")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The Id of resource group which the disk belongs.
     * > **NOTE:** Disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
     */
    @JvmName("tvbrarildwnjqsjp")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
     */
    @JvmName("bxfnjujdokmvkwfc")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
     */
    @JvmName("tjaoposddydlldls")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value
     */
    @JvmName("skjaxuaiqbaobmxg")
    public suspend fun storageSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSetId = mapped
    }

    /**
     * @param value
     */
    @JvmName("xuogpsyqelgkgess")
    public suspend fun storageSetPartitionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSetPartitionNumber = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("gyawggsxdfakvkiw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("nskkqsyjvxiwdipp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("ckddmlgpiswrroxl")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("jbotvefjkmwrnote")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        advancedFeatures = advancedFeatures,
        availabilityZone = availabilityZone,
        category = category,
        deleteAutoSnapshot = deleteAutoSnapshot,
        deleteWithInstance = deleteWithInstance,
        description = description,
        diskName = diskName,
        dryRun = dryRun,
        enableAutoSnapshot = enableAutoSnapshot,
        encryptAlgorithm = encryptAlgorithm,
        encrypted = encrypted,
        instanceId = instanceId,
        kmsKeyId = kmsKeyId,
        name = name,
        paymentType = paymentType,
        performanceLevel = performanceLevel,
        resourceGroupId = resourceGroupId,
        size = size,
        snapshotId = snapshotId,
        storageSetId = storageSetId,
        storageSetPartitionNumber = storageSetPartitionNumber,
        tags = tags,
        type = type,
        zoneId = zoneId,
    )
}
