@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EcsAutoSnapshotPolicyAttachment].
 */
@PulumiTagMarker
public class EcsAutoSnapshotPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsAutoSnapshotPolicyAttachmentArgs = EcsAutoSnapshotPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsAutoSnapshotPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = EcsAutoSnapshotPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsAutoSnapshotPolicyAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.ecs.EcsAutoSnapshotPolicyAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EcsAutoSnapshotPolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides a ECS Auto Snapshot Policy Attachment resource.
 * For information about ECS Auto Snapshot Policy Attachment and how to use it, see [What is Auto Snapshot Policy Attachment](https://www.alibabacloud.com/help/en/doc-detail/25531.htm).
 * > **NOTE:** Available in v1.122.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const exampleKey = new alicloud.kms.Key("example", {
 *     description: "terraform-example",
 *     pendingWindowInDays: 7,
 *     status: "Enabled",
 * });
 * const exampleAutoSnapshotPolicy = new alicloud.ecs.AutoSnapshotPolicy("example", {
 *     name: "terraform-example",
 *     repeatWeekdays: [
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retentionDays: -1,
 *     timePoints: [
 *         "1",
 *         "22",
 *         "23",
 *     ],
 * });
 * const exampleEcsDisk = new alicloud.ecs.EcsDisk("example", {
 *     zoneId: example.then(example => example.zones?.[0]?.id),
 *     diskName: "terraform-example",
 *     description: "Hello ecs disk.",
 *     category: "cloud_efficiency",
 *     size: 30,
 *     encrypted: true,
 *     kmsKeyId: exampleKey.id,
 *     tags: {
 *         Name: "terraform-example",
 *     },
 * });
 * const exampleEcsAutoSnapshotPolicyAttachment = new alicloud.ecs.EcsAutoSnapshotPolicyAttachment("example", {
 *     autoSnapshotPolicyId: exampleAutoSnapshotPolicy.id,
 *     diskId: exampleEcsDisk.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.get_zones(available_resource_creation="VSwitch")
 * example_key = alicloud.kms.Key("example",
 *     description="terraform-example",
 *     pending_window_in_days=7,
 *     status="Enabled")
 * example_auto_snapshot_policy = alicloud.ecs.AutoSnapshotPolicy("example",
 *     name="terraform-example",
 *     repeat_weekdays=[
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retention_days=-1,
 *     time_points=[
 *         "1",
 *         "22",
 *         "23",
 *     ])
 * example_ecs_disk = alicloud.ecs.EcsDisk("example",
 *     zone_id=example.zones[0].id,
 *     disk_name="terraform-example",
 *     description="Hello ecs disk.",
 *     category="cloud_efficiency",
 *     size=30,
 *     encrypted=True,
 *     kms_key_id=example_key.id,
 *     tags={
 *         "Name": "terraform-example",
 *     })
 * example_ecs_auto_snapshot_policy_attachment = alicloud.ecs.EcsAutoSnapshotPolicyAttachment("example",
 *     auto_snapshot_policy_id=example_auto_snapshot_policy.id,
 *     disk_id=example_ecs_disk.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var exampleKey = new AliCloud.Kms.Key("example", new()
 *     {
 *         Description = "terraform-example",
 *         PendingWindowInDays = 7,
 *         Status = "Enabled",
 *     });
 *     var exampleAutoSnapshotPolicy = new AliCloud.Ecs.AutoSnapshotPolicy("example", new()
 *     {
 *         Name = "terraform-example",
 *         RepeatWeekdays = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *         RetentionDays = -1,
 *         TimePoints = new[]
 *         {
 *             "1",
 *             "22",
 *             "23",
 *         },
 *     });
 *     var exampleEcsDisk = new AliCloud.Ecs.EcsDisk("example", new()
 *     {
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         DiskName = "terraform-example",
 *         Description = "Hello ecs disk.",
 *         Category = "cloud_efficiency",
 *         Size = 30,
 *         Encrypted = true,
 *         KmsKeyId = exampleKey.Id,
 *         Tags =
 *         {
 *             { "Name", "terraform-example" },
 *         },
 *     });
 *     var exampleEcsAutoSnapshotPolicyAttachment = new AliCloud.Ecs.EcsAutoSnapshotPolicyAttachment("example", new()
 *     {
 *         AutoSnapshotPolicyId = exampleAutoSnapshotPolicy.Id,
 *         DiskId = exampleEcsDisk.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:         pulumi.String("terraform-example"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 			Status:              pulumi.String("Enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAutoSnapshotPolicy, err := ecs.NewAutoSnapshotPolicy(ctx, "example", &ecs.AutoSnapshotPolicyArgs{
 * 			Name: pulumi.String("terraform-example"),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 			RetentionDays: int(-1),
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("22"),
 * 				pulumi.String("23"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleEcsDisk, err := ecs.NewEcsDisk(ctx, "example", &ecs.EcsDiskArgs{
 * 			ZoneId:      pulumi.String(example.Zones[0].Id),
 * 			DiskName:    pulumi.String("terraform-example"),
 * 			Description: pulumi.String("Hello ecs disk."),
 * 			Category:    pulumi.String("cloud_efficiency"),
 * 			Size:        pulumi.Int(30),
 * 			Encrypted:   pulumi.Bool(true),
 * 			KmsKeyId:    exampleKey.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("terraform-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsAutoSnapshotPolicyAttachment(ctx, "example", &ecs.EcsAutoSnapshotPolicyAttachmentArgs{
 * 			AutoSnapshotPolicyId: exampleAutoSnapshotPolicy.ID(),
 * 			DiskId:               exampleEcsDisk.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: alicloud:kms:Key
 *     name: example
 *     properties:
 *       description: terraform-example
 *       pendingWindowInDays: '7'
 *       status: Enabled
 *   exampleAutoSnapshotPolicy:
 *     type: alicloud:ecs:AutoSnapshotPolicy
 *     name: example
 *     properties:
 *       name: terraform-example
 *       repeatWeekdays:
 *         - '1'
 *         - '2'
 *         - '3'
 *       retentionDays: -1
 *       timePoints:
 *         - '1'
 *         - '22'
 *         - '23'
 *   exampleEcsDisk:
 *     type: alicloud:ecs:EcsDisk
 *     name: example
 *     properties:
 *       zoneId: ${example.zones[0].id}
 *       diskName: terraform-example
 *       description: Hello ecs disk.
 *       category: cloud_efficiency
 *       size: '30'
 *       encrypted: true
 *       kmsKeyId: ${exampleKey.id}
 *       tags:
 *         Name: terraform-example
 *   exampleEcsAutoSnapshotPolicyAttachment:
 *     type: alicloud:ecs:EcsAutoSnapshotPolicyAttachment
 *     name: example
 *     properties:
 *       autoSnapshotPolicyId: ${exampleAutoSnapshotPolicy.id}
 *       diskId: ${exampleEcsDisk.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Auto Snapshot Policy Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsAutoSnapshotPolicyAttachment:EcsAutoSnapshotPolicyAttachment example s-abcd12345:d-abcd12345
 * ```
 */
public class EcsAutoSnapshotPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsAutoSnapshotPolicyAttachment,
) : KotlinCustomResource(javaResource, EcsAutoSnapshotPolicyAttachmentMapper) {
    /**
     * The auto snapshot policy id.
     */
    public val autoSnapshotPolicyId: Output<String>
        get() = javaResource.autoSnapshotPolicyId().applyValue({ args0 -> args0 })

    /**
     * The disk id.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })
}

public object EcsAutoSnapshotPolicyAttachmentMapper :
    ResourceMapper<EcsAutoSnapshotPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsAutoSnapshotPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): EcsAutoSnapshotPolicyAttachment =
        EcsAutoSnapshotPolicyAttachment(
            javaResource as
                com.pulumi.alicloud.ecs.EcsAutoSnapshotPolicyAttachment,
        )
}

/**
 * @see [EcsAutoSnapshotPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsAutoSnapshotPolicyAttachment].
 */
public suspend fun ecsAutoSnapshotPolicyAttachment(
    name: String,
    block: suspend EcsAutoSnapshotPolicyAttachmentResourceBuilder.() -> Unit,
): EcsAutoSnapshotPolicyAttachment {
    val builder = EcsAutoSnapshotPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsAutoSnapshotPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsAutoSnapshotPolicyAttachment(name: String): EcsAutoSnapshotPolicyAttachment {
    val builder = EcsAutoSnapshotPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
