@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EcsDedicatedHostCluster].
 */
@PulumiTagMarker
public class EcsDedicatedHostClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsDedicatedHostClusterArgs = EcsDedicatedHostClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsDedicatedHostClusterArgsBuilder.() -> Unit) {
        val builder = EcsDedicatedHostClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsDedicatedHostCluster {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsDedicatedHostCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsDedicatedHostCluster(builtJavaResource)
    }
}

/**
 * Provides a ECS Dedicated Host Cluster resource.
 * For information about ECS Dedicated Host Cluster and how to use it, see [What is Dedicated Host Cluster](https://www.alibabacloud.com/help/en/doc-detail/184667.html).
 * > **NOTE:** Available since v1.146.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.getZones({});
 * const exampleEcsDedicatedHostCluster = new alicloud.ecs.EcsDedicatedHostCluster("example", {
 *     dedicatedHostClusterName: "example_value",
 *     description: "example_value",
 *     zoneId: example.then(example => example.zones?.[0]?.id),
 *     tags: {
 *         Create: "TF",
 *         For: "DDH_Cluster_Test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.get_zones()
 * example_ecs_dedicated_host_cluster = alicloud.ecs.EcsDedicatedHostCluster("example",
 *     dedicated_host_cluster_name="example_value",
 *     description="example_value",
 *     zone_id=example.zones[0].id,
 *     tags={
 *         "Create": "TF",
 *         "For": "DDH_Cluster_Test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.GetZones.Invoke();
 *     var exampleEcsDedicatedHostCluster = new AliCloud.Ecs.EcsDedicatedHostCluster("example", new()
 *     {
 *         DedicatedHostClusterName = "example_value",
 *         Description = "example_value",
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         Tags =
 *         {
 *             { "Create", "TF" },
 *             { "For", "DDH_Cluster_Test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := alicloud.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsDedicatedHostCluster(ctx, "example", &ecs.EcsDedicatedHostClusterArgs{
 * 			DedicatedHostClusterName: pulumi.String("example_value"),
 * 			Description:              pulumi.String("example_value"),
 * 			ZoneId:                   pulumi.String(example.Zones[0].Id),
 * 			Tags: pulumi.StringMap{
 * 				"Create": pulumi.String("TF"),
 * 				"For":    pulumi.String("DDH_Cluster_Test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsDedicatedHostCluster;
 * import com.pulumi.alicloud.ecs.EcsDedicatedHostClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = AlicloudFunctions.getZones();
 *         var exampleEcsDedicatedHostCluster = new EcsDedicatedHostCluster("exampleEcsDedicatedHostCluster", EcsDedicatedHostClusterArgs.builder()
 *             .dedicatedHostClusterName("example_value")
 *             .description("example_value")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Create", "TF"),
 *                 Map.entry("For", "DDH_Cluster_Test")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleEcsDedicatedHostCluster:
 *     type: alicloud:ecs:EcsDedicatedHostCluster
 *     name: example
 *     properties:
 *       dedicatedHostClusterName: example_value
 *       description: example_value
 *       zoneId: ${example.zones[0].id}
 *       tags:
 *         Create: TF
 *         For: DDH_Cluster_Test
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Dedicated Host Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDedicatedHostCluster:EcsDedicatedHostCluster example <id>
 * ```
 */
public class EcsDedicatedHostCluster internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsDedicatedHostCluster,
) : KotlinCustomResource(javaResource, EcsDedicatedHostClusterMapper) {
    /**
     * The name of the dedicated host cluster. The name must be `2` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter. It cannot contain `http://` or `https://`.
     */
    public val dedicatedHostClusterName: Output<String>?
        get() = javaResource.dedicatedHostClusterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the dedicated host cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the zone in which to create the dedicated host cluster.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object EcsDedicatedHostClusterMapper : ResourceMapper<EcsDedicatedHostCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsDedicatedHostCluster::class == javaResource::class

    override fun map(javaResource: Resource): EcsDedicatedHostCluster =
        EcsDedicatedHostCluster(javaResource as com.pulumi.alicloud.ecs.EcsDedicatedHostCluster)
}

/**
 * @see [EcsDedicatedHostCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsDedicatedHostCluster].
 */
public suspend fun ecsDedicatedHostCluster(
    name: String,
    block: suspend EcsDedicatedHostClusterResourceBuilder.() -> Unit,
): EcsDedicatedHostCluster {
    val builder = EcsDedicatedHostClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsDedicatedHostCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsDedicatedHostCluster(name: String): EcsDedicatedHostCluster {
    val builder = EcsDedicatedHostClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
