@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsDedicatedHostClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Dedicated Host Cluster resource.
 * For information about ECS Dedicated Host Cluster and how to use it, see [What is Dedicated Host Cluster](https://www.alibabacloud.com/help/en/doc-detail/184667.html).
 * > **NOTE:** Available since v1.146.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.getZones({});
 * const exampleEcsDedicatedHostCluster = new alicloud.ecs.EcsDedicatedHostCluster("example", {
 *     dedicatedHostClusterName: "example_value",
 *     description: "example_value",
 *     zoneId: example.then(example => example.zones?.[0]?.id),
 *     tags: {
 *         Create: "TF",
 *         For: "DDH_Cluster_Test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.get_zones()
 * example_ecs_dedicated_host_cluster = alicloud.ecs.EcsDedicatedHostCluster("example",
 *     dedicated_host_cluster_name="example_value",
 *     description="example_value",
 *     zone_id=example.zones[0].id,
 *     tags={
 *         "Create": "TF",
 *         "For": "DDH_Cluster_Test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.GetZones.Invoke();
 *     var exampleEcsDedicatedHostCluster = new AliCloud.Ecs.EcsDedicatedHostCluster("example", new()
 *     {
 *         DedicatedHostClusterName = "example_value",
 *         Description = "example_value",
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         Tags =
 *         {
 *             { "Create", "TF" },
 *             { "For", "DDH_Cluster_Test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := alicloud.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsDedicatedHostCluster(ctx, "example", &ecs.EcsDedicatedHostClusterArgs{
 * 			DedicatedHostClusterName: pulumi.String("example_value"),
 * 			Description:              pulumi.String("example_value"),
 * 			ZoneId:                   pulumi.String(example.Zones[0].Id),
 * 			Tags: pulumi.StringMap{
 * 				"Create": pulumi.String("TF"),
 * 				"For":    pulumi.String("DDH_Cluster_Test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsDedicatedHostCluster;
 * import com.pulumi.alicloud.ecs.EcsDedicatedHostClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = AlicloudFunctions.getZones();
 *         var exampleEcsDedicatedHostCluster = new EcsDedicatedHostCluster("exampleEcsDedicatedHostCluster", EcsDedicatedHostClusterArgs.builder()
 *             .dedicatedHostClusterName("example_value")
 *             .description("example_value")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Create", "TF"),
 *                 Map.entry("For", "DDH_Cluster_Test")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleEcsDedicatedHostCluster:
 *     type: alicloud:ecs:EcsDedicatedHostCluster
 *     name: example
 *     properties:
 *       dedicatedHostClusterName: example_value
 *       description: example_value
 *       zoneId: ${example.zones[0].id}
 *       tags:
 *         Create: TF
 *         For: DDH_Cluster_Test
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Dedicated Host Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDedicatedHostCluster:EcsDedicatedHostCluster example <id>
 * ```
 * @property dedicatedHostClusterName The name of the dedicated host cluster. The name must be `2` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter. It cannot contain `http://` or `https://`.
 * @property description The description of the dedicated host cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
 * @property dryRun The dry run.
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId The ID of the zone in which to create the dedicated host cluster.
 */
public data class EcsDedicatedHostClusterArgs(
    public val dedicatedHostClusterName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsDedicatedHostClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsDedicatedHostClusterArgs =
        com.pulumi.alicloud.ecs.EcsDedicatedHostClusterArgs.builder()
            .dedicatedHostClusterName(dedicatedHostClusterName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsDedicatedHostClusterArgs].
 */
@PulumiTagMarker
public class EcsDedicatedHostClusterArgsBuilder internal constructor() {
    private var dedicatedHostClusterName: Output<String>? = null

    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The name of the dedicated host cluster. The name must be `2` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter. It cannot contain `http://` or `https://`.
     */
    @JvmName("phrgwgymohuibqyg")
    public suspend fun dedicatedHostClusterName(`value`: Output<String>) {
        this.dedicatedHostClusterName = value
    }

    /**
     * @param value The description of the dedicated host cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
     */
    @JvmName("fiswpmouuwukhcoe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("owlgveaefqveqitq")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("rnukrdbxbtlquqtp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the zone in which to create the dedicated host cluster.
     */
    @JvmName("qawljnimhicmptec")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The name of the dedicated host cluster. The name must be `2` to `128` characters in length and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter. It cannot contain `http://` or `https://`.
     */
    @JvmName("reaobsueplrbplnu")
    public suspend fun dedicatedHostClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostClusterName = mapped
    }

    /**
     * @param value The description of the dedicated host cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
     */
    @JvmName("vyjjdlpldmcgdsry")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("etjmbcjwnlhyumac")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("aumgyroqfttovmeh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ymrevoxntvokelrd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the zone in which to create the dedicated host cluster.
     */
    @JvmName("cwahsiswcpemkyox")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): EcsDedicatedHostClusterArgs = EcsDedicatedHostClusterArgs(
        dedicatedHostClusterName = dedicatedHostClusterName,
        description = description,
        dryRun = dryRun,
        tags = tags,
        zoneId = zoneId,
    )
}
